/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.seam;

import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.jsf.concurrency.AbstractResolver;
import org.jboss.seam.jsf.concurrency.ConcurrentRequestResolver;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="org.jboss.seam.jsf.concurrency.ConcurrentRequestResolver")
@Install(precedence=10)
@BypassInterceptors
public class NuxeoConcurrentRequestResolver
extends AbstractResolver
implements ConcurrentRequestResolver {
    public boolean handleConcurrentRequest(ConversationEntry ce, HttpServletRequest request, HttpServletResponse response) {
        if (request.getMethod().equalsIgnoreCase("get")) {
            request.setAttribute("DisableActionBinding", (Object)true);
            this.addTransientMessage(StatusMessage.Severity.WARN, "org.nuxeo.seam.concurrent.unsaferun", "This page may be not up to date, an other concurrent requests is still running");
            return true;
        }
        if (request.getMethod().equalsIgnoreCase("post")) {
            if (FacesContext.getCurrentInstance() == null) {
                return false;
            }
            String url = request.getHeader("referer");
            if (url == null || url.length() == 0) {
                url = VirtualHostHelper.getServerURL((ServletRequest)request) + request.getRequestURI();
            }
            this.addTransientMessage(StatusMessage.Severity.WARN, "org.nuxeo.seam.concurrent.skip", "Your request was not processed because you already have a requests in processing.");
            return this.handleRedirect(ce, response, url);
        }
        return this.handleNoResponse(response);
    }
}

