/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.handler;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.jsf.ComponentConfig;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.faces.application.Application;
import javax.faces.component.ActionSource2;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.tag.handler.GenericHtmlComponentHandler;

public class DocumentLinkTagHandler
extends GenericHtmlComponentHandler {
    private static final Log log = LogFactory.getLog(DocumentLinkTagHandler.class);
    private final TagAttribute document = this.getRequiredAttribute("document");
    private final TagAttribute view = this.getAttribute("view");

    public DocumentLinkTagHandler(ComponentConfig config) {
        super(config);
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset mr = super.createMetaRuleset(type);
        mr.alias("title", "value");
        mr.ignore("document");
        mr.ignore("action");
        mr.ignore("view");
        return mr;
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        if (c instanceof ActionSource2) {
            ActionSource2 command = (ActionSource2)c;
            String docValue = this.getDocumentValue();
            String viewId = this.getViewValue();
            String actionValue = viewId == null ? "#{navigationContext.navigateToDocument(" + docValue + ")}" : "#{navigationContext.navigateToDocumentWithView(" + docValue + ", " + viewId + ")}";
            FacesContext facesContext = ctx.getFacesContext();
            Application app = facesContext.getApplication();
            ExpressionFactory ef = app.getExpressionFactory();
            ELContext context = facesContext.getELContext();
            MethodExpression action = ef.createMethodExpression(context, actionValue, String.class, new Class[]{DocumentModel.class, String.class});
            command.setActionExpression(action);
        }
    }

    private String getDocumentValue() {
        String docValue = this.document.getValue();
        if (!(docValue = docValue.trim()).startsWith("${") && !docValue.startsWith("#{") || !docValue.endsWith("}")) {
            log.error((Object)("Invalid value for document " + docValue));
        }
        docValue = docValue.substring(2, docValue.length() - 1);
        return docValue;
    }

    private String getViewValue() {
        String viewName = null;
        if (this.view != null && (viewName = this.view.getValue()) != null) {
            viewName = ((viewName = viewName.trim()).startsWith("${") || viewName.startsWith("#{")) && viewName.endsWith("}") ? viewName.substring(2, viewName.length() - 1) : '\"' + viewName + '\"';
        }
        return viewName;
    }
}

