/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupOperationContext
extends AbstractOperationContext {
    private List<String> attrsId;
    private List<String> attrsOid;

    public LookupOperationContext() {
    }

    public LookupOperationContext(LdapDN dn) {
        super(dn);
    }

    public LookupOperationContext(String[] attrsId) {
        this.attrsId = new ArrayList<String>();
        this.attrsOid = new ArrayList<String>();
        this.setAttrsId(attrsId);
    }

    public LookupOperationContext(LdapDN dn, String[] attrsId) {
        super(dn);
        this.attrsId = new ArrayList<String>();
        this.attrsOid = new ArrayList<String>();
        this.setAttrsId(attrsId);
    }

    public String[] getAttrsIdArray() {
        String[] attrs = new String[this.attrsId.size()];
        return this.attrsId.toArray(attrs);
    }

    public void setAttrsId(String[] attrsId) {
        this.attrsId = attrsId == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(attrsId));
    }

    public String[] getAttrsOidArray() {
        String[] attrs = new String[this.attrsId.size()];
        return this.attrsOid.toArray(attrs);
    }

    public void setAttrsOid(String[] attrsOid) {
        this.attrsOid = attrsOid == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(attrsOid));
    }

    public void addAttrsOid(String attrOid) {
        if (this.attrsOid == null) {
            this.attrsOid = new ArrayList<String>();
        }
        this.attrsOid.add(attrOid);
    }

    public void addAttrsId(String attrId) {
        if (this.attrsId == null) {
            this.attrsId = new ArrayList<String>();
        }
        this.attrsId.add(attrId);
    }

    public void addAttrs(String attrId, String attrOid) {
        if (this.attrsId == null) {
            this.attrsId = new ArrayList<String>();
        }
        if (this.attrsOid == null) {
            this.attrsOid = new ArrayList<String>();
        }
        this.attrsId.add(attrId);
        this.attrsOid.add(attrOid);
    }

    public List<String> getAttrsId() {
        return this.attrsId;
    }

    public List<String> getAttrsOid() {
        return this.attrsOid;
    }

    public String toString() {
        return "LookupContext for DN '" + this.getDn().getUpName() + "'" + (this.attrsId != null ? ", attributes : <" + StringTools.listToString(this.attrsId) + ">" : "");
    }
}

