/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.jndi.JavaLdapSupport;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParserImpl;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerDirContext
extends ServerContext
implements EventDirContext {
    private final FilterParserImpl filterParser = new FilterParserImpl();

    public ServerDirContext(DirectoryService service, Hashtable env) throws NamingException {
        super(service, env);
    }

    protected ServerDirContext(DirectoryService service, LdapPrincipal principal, Name dn) throws NamingException {
        super(service, principal, dn);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes((Name)new LdapDN(name));
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.doLookupOperation(this.buildTarget(name));
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes((Name)new LdapDN(name), attrIds);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.doLookupOperation(this.buildTarget(name), attrIds);
    }

    @Override
    public void modifyAttributes(String name, int modOp, Attributes attrs) throws NamingException {
        this.modifyAttributes((Name)new LdapDN(name), modOp, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public void modifyAttributes(Name name, int modOp, Attributes attrs) throws NamingException {
        ModificationItemImpl[] modItems = null;
        if (attrs != null) {
            modItems = new ModificationItemImpl[attrs.size()];
            NamingEnumeration<? extends Attribute> e = attrs.getAll();
            int i = 0;
            while (e.hasMore()) {
                modItems[i++] = new ModificationItemImpl(modOp, e.next());
            }
        }
        if (name instanceof LdapDN) {
            this.doModifyOperation(this.buildTarget(name), modItems);
        } else {
            this.doModifyOperation(this.buildTarget((Name)new LdapDN(name)), modItems);
        }
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        ModificationItemImpl[] newMods = new ModificationItemImpl[mods.length];
        for (int i = 0; i < mods.length; ++i) {
            newMods[i] = new ModificationItemImpl(mods[i]);
        }
        this.modifyAttributes((Name)new LdapDN(name), newMods);
    }

    public void modifyAttributes(String name, ModificationItemImpl[] mods) throws NamingException {
        this.modifyAttributes((Name)new LdapDN(name), mods);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        ModificationItemImpl[] newMods = new ModificationItemImpl[mods.length];
        for (int i = 0; i < mods.length; ++i) {
            newMods[i] = new ModificationItemImpl(mods[i]);
        }
        this.doModifyOperation(this.buildTarget((Name)new LdapDN(name)), newMods);
    }

    public void modifyAttributes(Name name, ModificationItemImpl[] mods) throws NamingException {
        this.doModifyOperation(this.buildTarget((Name)new LdapDN(name)), mods);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind((Name)new LdapDN(name), obj, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (null == obj && null == attrs) {
            throw new NamingException("Both obj and attrs args are null. At least one of these parameters must not be null.");
        }
        if (null == attrs) {
            super.bind(name, obj);
            return;
        }
        attrs = AttributeUtils.toCaseInsensitive((Attributes)attrs);
        if (null == obj) {
            Attributes clone = (Attributes)attrs.clone();
            LdapDN target = this.buildTarget(name);
            this.doAddOperation(target, clone);
            return;
        }
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.getEnvironment(), attrs);
        Attributes outAttrs = res.getAttributes();
        if (outAttrs != attrs) {
            LdapDN target = this.buildTarget(name);
            Attributes attributes = (Attributes)attrs.clone();
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            this.doAddOperation(target, attributes);
            return;
        }
        if (obj instanceof Referenceable) {
            throw new NamingException("Do not know how to store Referenceables yet!");
        }
        if (obj instanceof Reference) {
            throw new NamingException("Do not know how to store References yet!");
        }
        if (obj instanceof Serializable) {
            Attributes attributes = (Attributes)attrs.clone();
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            LdapDN target = this.buildTarget(name);
            JavaLdapSupport.serialize(attributes, obj);
            this.doAddOperation(target, attributes);
        } else if (obj instanceof DirContext) {
            Attributes attributes = ((DirContext)obj).getAttributes("");
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            LdapDN target = this.buildTarget(name);
            this.doAddOperation(target, attributes);
        } else {
            throw new NamingException("Can't find a way to bind: " + obj);
        }
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind((Name)new LdapDN(name), obj, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        LdapDN target = this.buildTarget(name);
        if (this.getNexusProxy().hasEntry(new EntryOperationContext(target))) {
            this.doDeleteOperation(target);
        }
        this.bind(name, obj, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSubcontext((Name)new LdapDN(name), AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        if (null == attrs) {
            return (DirContext)super.createSubcontext(name);
        }
        LdapDN target = this.buildTarget(name);
        Rdn rdn = target.getRdn(target.size() - 1);
        attrs = AttributeUtils.toCaseInsensitive((Attributes)attrs);
        Attributes attributes = (Attributes)attrs.clone();
        if (rdn.size() == 1) {
            String rdnAttribute = rdn.getUpType();
            String rdnValue = (String)rdn.getValue();
            boolean doRdnPut = attributes.get(rdnAttribute) == null;
            doRdnPut = doRdnPut || attributes.get(rdnAttribute).size() == 0;
            boolean bl = doRdnPut = doRdnPut || !attributes.get(rdnAttribute).contains(rdnValue);
            if (doRdnPut) {
                attributes.put(rdnAttribute, rdnValue);
            }
        } else {
            for (AttributeTypeAndValue atav : rdn) {
                boolean doRdnPut = attributes.get(atav.getNormType()) == null;
                doRdnPut = doRdnPut || attributes.get(atav.getNormType()).size() == 0;
                if (!(doRdnPut = doRdnPut || !attributes.get(atav.getNormType()).contains(atav.getValue()))) continue;
                attributes.put(atav.getNormType(), atav.getValue());
            }
        }
        this.doAddOperation(target, attributes);
        return new ServerLdapContext(this.getService(), this.getPrincipal(), target);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search((Name)new LdapDN(name), matchingAttributes, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, AttributeUtils.toCaseInsensitive((Attributes)matchingAttributes), null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search((Name)new LdapDN(name), AttributeUtils.toCaseInsensitive((Attributes)matchingAttributes), attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        SearchControls ctls = new SearchControls();
        LdapDN target = this.buildTarget(name);
        if (null != attributesToReturn) {
            ctls.setReturningAttributes(attributesToReturn);
        }
        if (null == (matchingAttributes = AttributeUtils.toCaseInsensitive((Attributes)matchingAttributes)) || matchingAttributes.size() <= 0) {
            PresenceNode filter = new PresenceNode("objectClass");
            return this.doSearchOperation(target, this.getEnvironment(), (ExprNode)filter, ctls);
        }
        if (matchingAttributes.size() == 1) {
            NamingEnumeration<? extends Attribute> list = matchingAttributes.getAll();
            Attribute attr = list.next();
            list.close();
            if (attr.size() == 1) {
                Object value = attr.get();
                SimpleNode node = value instanceof byte[] ? new SimpleNode(attr.getID(), (byte[])value, AssertionEnum.EQUALITY) : new SimpleNode(attr.getID(), (String)value, AssertionEnum.EQUALITY);
                return this.doSearchOperation(target, this.getEnvironment(), (ExprNode)node, ctls);
            }
        }
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        NamingEnumeration<? extends Attribute> list = matchingAttributes.getAll();
        while (list.hasMore()) {
            Attribute attr = list.next();
            if (attr.size() == 0) {
                filter.addNode((ExprNode)new PresenceNode(attr.getID()));
                continue;
            }
            for (int ii = 0; ii < attr.size(); ++ii) {
                Object val = attr.get(ii);
                if (!(val instanceof String)) continue;
                SimpleNode node = new SimpleNode(attr.getID(), (String)val, AssertionEnum.EQUALITY);
                filter.addNode((ExprNode)node);
            }
        }
        return this.doSearchOperation(target, this.getEnvironment(), (ExprNode)filter, ctls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search((Name)new LdapDN(name), filter, cons);
    }

    public NamingEnumeration<SearchResult> search(Name name, ExprNode filter, SearchControls cons) throws NamingException {
        LdapDN target = this.buildTarget(name);
        return this.doSearchOperation(target, this.getEnvironment(), filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        ExprNode filterNode;
        LdapDN target = this.buildTarget(name);
        try {
            filterNode = this.filterParser.parse(filter);
        }
        catch (ParseException pe) {
            InvalidSearchFilterException isfe = new InvalidSearchFilterException("Encountered parse exception while parsing the filter: '" + filter + "'");
            isfe.setRootCause(pe);
            throw isfe;
        }
        catch (IOException ioe) {
            NamingException ne = new NamingException("Parser failed with IO exception on filter: '" + filter + "'");
            ne.setRootCause(ioe);
            throw ne;
        }
        return this.doSearchOperation(target, this.getEnvironment(), filterNode, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search((Name)new LdapDN(name), filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        StringBuffer buf = new StringBuffer(filterExpr);
        for (int ii = 0; ii < buf.length(); ++ii) {
            int start;
            try {
                while (ii < buf.length() && '{' != buf.charAt(ii)) {
                    ++ii;
                }
                start = ii;
                while ('}' != buf.charAt(ii)) {
                    ++ii;
                }
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            int index = Integer.parseInt(buf.substring(start + 1, ii));
            if (filterArgs[index] instanceof String) {
                buf.replace(start, ii + 1, (String)filterArgs[index]);
                continue;
            }
            if (filterArgs[index] instanceof byte[]) {
                String hexstr = "#" + StringTools.toHexString((byte[])((byte[])filterArgs[index]));
                buf.replace(start, ii + 1, hexstr);
                continue;
            }
            buf.replace(start, ii + 1, filterArgs[index].toString());
        }
        return this.search(name, buf.toString(), cons);
    }

    @Override
    public void addNamingListener(Name name, String filterStr, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        ExprNode filter;
        try {
            filter = this.filterParser.parse(filterStr);
        }
        catch (Exception e) {
            NamingException e2 = new NamingException("could not parse filter: " + filterStr);
            e2.setRootCause(e);
            throw e2;
        }
        ((PartitionNexusProxy)this.getNexusProxy()).addNamingListener(this, (Name)this.buildTarget(name), filter, searchControls, namingListener);
        this.getListeners().add(namingListener);
    }

    @Override
    public void addNamingListener(String name, String filter, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener((Name)new LdapDN(name), filter, searchControls, namingListener);
    }

    @Override
    public void addNamingListener(Name name, String filterExpr, Object[] filterArgs, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        StringBuffer buf = new StringBuffer(filterExpr);
        for (int ii = 0; ii < buf.length(); ++ii) {
            while ('{' != buf.charAt(ii)) {
                ++ii;
            }
            int start = ii;
            while ('}' != buf.charAt(ii)) {
                ++ii;
            }
            buf.replace(start, ii + 1, filterArgs[ii].toString());
        }
        this.addNamingListener(name, buf.toString(), searchControls, namingListener);
    }

    @Override
    public void addNamingListener(String name, String filter, Object[] objects, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener((Name)new LdapDN(name), filter, objects, searchControls, namingListener);
    }
}

