/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.schema.AbstractSchemaChangeHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.NormalizerRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.NamespaceTools;

public class MetaNormalizerHandler
extends AbstractSchemaChangeHandler {
    private final SchemaEntityFactory factory;
    private final NormalizerRegistry normalizerRegistry;
    private final MatchingRuleRegistry matchingRuleRegistry;
    private final AttributeType byteCodeAT;
    private final AttributeType descAT;
    private final AttributeType fqcnAT;

    public MetaNormalizerHandler(Registries targetRegistries, PartitionSchemaLoader loader) throws NamingException {
        super(targetRegistries, loader);
        this.normalizerRegistry = targetRegistries.getNormalizerRegistry();
        this.matchingRuleRegistry = targetRegistries.getMatchingRuleRegistry();
        this.factory = new SchemaEntityFactory(targetRegistries);
        this.byteCodeAT = targetRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
        this.descAT = targetRegistries.getAttributeTypeRegistry().lookup("m-description");
        this.fqcnAT = targetRegistries.getAttributeTypeRegistry().lookup("m-fqcn");
    }

    private NormalizerDescription getNormalizerDescription(String schemaName, Attributes entry) throws NamingException {
        Attribute bytecode;
        NormalizerDescription description = new NormalizerDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn((String)AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.fqcnAT).get());
        Attribute desc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription((String)desc.get());
        }
        if ((bytecode = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = (byte[])bytecode.get();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    protected void modify(LdapDN name, Attributes entry, Attributes targetEntry, boolean cascade) throws NamingException {
        String oid = this.getOid(entry);
        Normalizer normalizer = this.factory.getNormalizer(targetEntry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            this.normalizerRegistry.unregister(oid);
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(schema.getSchemaName(), targetEntry);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    public void add(LdapDN name, Attributes entry) throws NamingException {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkNewParent(parentDn);
        this.checkOidIsUniqueForNormalizer(entry);
        Normalizer normalizer = this.factory.getNormalizer(entry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(schema.getSchemaName(), entry);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    public void add(NormalizerDescription normalizerDescription) throws NamingException {
        Schema schema;
        Normalizer normalizer = this.factory.getNormalizer(normalizerDescription, this.targetRegistries);
        String schemaName = "other";
        if (normalizerDescription.getExtensions().get("X-SCHEMA") != null) {
            schemaName = (String)((List)normalizerDescription.getExtensions().get("X-SCHEMA")).get(0);
        }
        if (!(schema = this.loader.getSchema(schemaName)).isDisabled()) {
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    public void delete(LdapDN name, Attributes entry, boolean cascade) throws NamingException {
        this.delete(this.getOid(entry), cascade);
    }

    public void delete(String oid, boolean cascade) throws NamingException {
        if (this.matchingRuleRegistry.hasMatchingRule(oid)) {
            throw new LdapOperationNotSupportedException("The normalizer with OID " + oid + " cannot be deleted until all " + "matchingRules using that normalizer have also been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        if (this.normalizerRegistry.hasNormalizer(oid)) {
            this.normalizerRegistry.unregister(oid);
        }
    }

    public void rename(LdapDN name, Attributes entry, String newRdn, boolean cascade) throws NamingException {
        String oldOid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oldOid)) {
            throw new LdapOperationNotSupportedException("The normalizer with OID " + oldOid + " cannot have it's OID changed until all " + "matchingRules using that normalizer have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = NamespaceTools.getRdnValue((String)newRdn);
        this.checkOidIsUniqueForNormalizer(oid);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            Normalizer normalizer = this.factory.getNormalizer(entry, this.targetRegistries);
            this.normalizerRegistry.unregister(oldOid);
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(schema.getSchemaName(), entry);
            normalizerDescription.setNumericOid(oid);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn, Attributes entry, boolean cascade) throws NamingException {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oldOid)) {
            throw new LdapOperationNotSupportedException("The normalizer with OID " + oldOid + " cannot have it's OID changed until all " + "matchingRules using that normalizer have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = NamespaceTools.getRdnValue((String)newRn);
        this.checkOidIsUniqueForNormalizer(oid);
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        Normalizer normalizer = this.factory.getNormalizer(entry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.normalizerRegistry.unregister(oldOid);
        }
        if (!newSchema.isDisabled()) {
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(newSchema.getSchemaName(), entry);
            normalizerDescription.setNumericOid(oid);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, Attributes entry, boolean cascade) throws NamingException {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oid)) {
            throw new LdapOperationNotSupportedException("The normalizer with OID " + oid + " cannot be moved to another schema until all " + "matchingRules using that normalizer have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        Normalizer normalizer = this.factory.getNormalizer(entry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.normalizerRegistry.unregister(oid);
        }
        if (!newSchema.isDisabled()) {
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(newSchema.getSchemaName(), entry);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    private void checkOidIsUniqueForNormalizer(String oid) throws NamingException {
        if (this.targetRegistries.getNormalizerRegistry().hasNormalizer(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema normalizer is not unique.", ResultCodeEnum.OTHER);
        }
    }

    private void checkOidIsUniqueForNormalizer(Attributes entry) throws NamingException {
        String oid = this.getOid(entry);
        if (this.targetRegistries.getNormalizerRegistry().hasNormalizer(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema normalizer is not unique.", ResultCodeEnum.OTHER);
        }
    }

    private void checkNewParent(LdapDN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException("The parent dn of a normalizer should be at most 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
        }
        Rdn rdn = newParent.getRdn();
        if (!this.targetRegistries.getOidRegistry().getOid(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException("The parent entry of a normalizer should be an organizationalUnit.", ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!((String)rdn.getValue()).equalsIgnoreCase("normalizers")) {
            throw new LdapInvalidNameException("The parent entry of a normalizer should have a relative name of ou=normalizers.", ResultCodeEnum.NAMING_VIOLATION);
        }
    }
}

