/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Properties;
import javax.naming.InitialContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.JndiServiceLocator;
import org.nuxeo.runtime.api.ServiceDescriptor;

public class JBossServiceLocator
extends JndiServiceLocator {
    private static final long serialVersionUID = -5691359964790311122L;
    private String prefix = "";
    private String suffix = "";

    @Override
    public void initialize(String host, int port, Properties properties) throws Exception {
        if (port == 0) {
            port = 1099;
        }
        if (properties != null) {
            this.prefix = properties.getProperty("prefix", "nuxeo/");
            this.suffix = properties.getProperty("suffix", JBossServiceLocator.getDefaultSuffix());
            String value = properties.getProperty("java.naming.provider.url");
            if (value != null) {
                value = String.format(value, host, port);
                properties.put("java.naming.provider.url", value);
            }
        }
        this.context = new InitialContext(properties);
    }

    @Override
    public Object lookup(ServiceDescriptor sd) throws Exception {
        String locator = sd.getLocator();
        if (locator == null) {
            locator = this.prefix + sd.getServiceClassSimpleName() + this.suffix;
            sd.setLocator(locator);
        } else if (locator.startsWith("%")) {
            locator = this.prefix + locator.substring(1) + this.suffix;
            sd.setLocator(locator);
        }
        return this.lookup(locator);
    }

    public static String getDefaultSuffix() {
        if (Framework.getProperty("nuxeo.client.on.jboss") != null) {
            return "/remote";
        }
        return System.getProperty("jboss.home.dir") == null ? "/remote" : "/local";
    }
}

