/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.SearchResult;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.SamType;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntryModifier;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;

public class GetPrincipal
implements ContextOperation {
    private static final long serialVersionUID = 4598007518413451945L;
    private final KerberosPrincipal principal;

    public GetPrincipal(KerberosPrincipal principal) {
        this.principal = principal;
    }

    public Object execute(DirContext ctx, Name base) {
        if (this.principal == null) {
            return null;
        }
        String[] attrIDs = new String[]{"krb5PrincipalName", "krb5KeyVersionNumber", "krb5Key", "apacheSamType", "krb5AccountDisabled", "krb5AccountExpirationTime", "krb5AccountLockedOut"};
        AttributesImpl matchAttrs = new AttributesImpl(true);
        matchAttrs.put((Attribute)new AttributeImpl("krb5PrincipalName", (Object)this.principal.getName()));
        PrincipalStoreEntry entry = null;
        try {
            NamingEnumeration<SearchResult> answer = ctx.search("", (Attributes)matchAttrs, attrIDs);
            if (answer.hasMore()) {
                SearchResult result = answer.next();
                Attributes attrs = result.getAttributes();
                if (attrs == null) {
                    return null;
                }
                String distinguishedName = result.getName();
                entry = this.getEntry(distinguishedName, attrs);
            }
        }
        catch (NamingException e) {
            return null;
        }
        return entry;
    }

    private PrincipalStoreEntry getEntry(String distinguishedName, Attributes attrs) throws NamingException {
        String val;
        PrincipalStoreEntryModifier modifier = new PrincipalStoreEntryModifier();
        modifier.setDistinguishedName(distinguishedName);
        String principal = (String)attrs.get("krb5PrincipalName").get();
        modifier.setPrincipal(new KerberosPrincipal(principal));
        String keyVersionNumber = (String)attrs.get("krb5KeyVersionNumber").get();
        modifier.setKeyVersionNumber(Integer.parseInt(keyVersionNumber));
        if (attrs.get("krb5AccountDisabled") != null) {
            val = (String)attrs.get("krb5AccountDisabled").get();
            modifier.setDisabled("true".equalsIgnoreCase(val));
        }
        if (attrs.get("krb5AccountLockedOut") != null) {
            val = (String)attrs.get("krb5AccountLockedOut").get();
            modifier.setLockedOut("true".equalsIgnoreCase(val));
        }
        if (attrs.get("krb5AccountExpirationTime") != null) {
            val = (String)attrs.get("krb5AccountExpirationTime").get();
            try {
                modifier.setExpiration(KerberosTime.getTime(val));
            }
            catch (ParseException e) {
                throw new InvalidAttributeValueException("Account expiration attribute krb5AccountExpirationTime contained an invalid value for generalizedTime: " + val);
            }
        }
        if (attrs.get("apacheSamType") != null) {
            String samType = (String)attrs.get("apacheSamType").get();
            modifier.setSamType(SamType.getTypeByOrdinal(Integer.parseInt(samType)));
        }
        if (attrs.get("krb5Key") != null) {
            Attribute krb5key = attrs.get("krb5Key");
            try {
                Map<EncryptionType, EncryptionKey> keyMap = modifier.reconstituteKeyMap(krb5key);
                modifier.setKeyMap(keyMap);
            }
            catch (IOException ioe) {
                throw new InvalidAttributeValueException("Account Kerberos key attribute 'krb5Key' contained an invalid value for krb5key.");
            }
        }
        return modifier.getEntry();
    }
}

