/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.trace.Trace;
import org.nuxeo.ecm.automation.core.trace.Tracer;
import org.nuxeo.ecm.automation.core.trace.TracerFactoryMBean;
import org.nuxeo.ecm.automation.core.trace.TracerLite;
import org.nuxeo.runtime.api.Framework;

public class TracerFactory
implements TracerFactoryMBean {
    public static final String AUTOMATION_TRACE_PROPERTY = "org.nuxeo.automation.trace";
    public static final String AUTOMATION_TRACE_PRINTABLE_PROPERTY = "org.nuxeo.automation.trace.printable";
    protected static final Integer CACHE_CONCURRENCY_LEVEL = 10;
    protected static final Integer CACHE_MAXIMUM_SIZE = 1000;
    protected static final Integer CACHE_TIMEOUT = 1;
    private static final Log log = LogFactory.getLog(TracerFactory.class);
    protected String printableTraces;
    protected Cache<String, ChainTraces> tracesCache = CacheBuilder.newBuilder().concurrencyLevel(CACHE_CONCURRENCY_LEVEL.intValue()).maximumSize((long)CACHE_MAXIMUM_SIZE.intValue()).expireAfterWrite((long)CACHE_TIMEOUT.intValue(), TimeUnit.HOURS).build();
    protected boolean recording = Framework.isBooleanPropertyTrue((String)"org.nuxeo.automation.trace");
    protected Trace lastError;

    public TracerFactory() {
        this.printableTraces = Framework.getProperty((String)AUTOMATION_TRACE_PRINTABLE_PROPERTY, (String)"*");
    }

    public OperationCallback newTracer(String operationTypeId) {
        if (this.recording) {
            return new Tracer(this, this.printable(operationTypeId));
        }
        return new TracerLite(this);
    }

    protected Boolean printable(String operationTypeId) {
        if (!"*".equals(this.printableTraces)) {
            try {
                String[] printableTraces = this.printableTraces.split(",");
                return Arrays.asList(printableTraces).contains(operationTypeId);
            }
            catch (PatternSyntaxException e) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The property ");
                stringBuilder.append(AUTOMATION_TRACE_PRINTABLE_PROPERTY);
                stringBuilder.append(":");
                stringBuilder.append(this.printableTraces);
                stringBuilder.append(" is wrongly set. All automation traces are printable.");
                log.info((Object)stringBuilder.toString(), (Throwable)e);
                return true;
            }
        }
        return true;
    }

    public String recordTrace(Trace trace) {
        String chainId = trace.chain.getId();
        ChainTraces chainTraces = (ChainTraces)this.tracesCache.getIfPresent((Object)chainId);
        if (chainTraces == null) {
            this.tracesCache.put((Object)chainId, (Object)new ChainTraces(trace.chain));
        }
        if (trace.getError() != null) {
            this.lastError = trace;
        }
        return ((ChainTraces)this.tracesCache.getIfPresent((Object)chainId)).add(trace);
    }

    public Trace getTrace(OperationChain chain, int index) {
        return ((ChainTraces)this.tracesCache.getIfPresent((Object)chain.getId())).getTrace(index);
    }

    public Trace getTrace(String key) {
        return this.getTrace(key, -1);
    }

    public Trace getTrace(String key, int index) {
        ChainTraces chainTrace = (ChainTraces)this.tracesCache.getIfPresent((Object)key);
        if (chainTrace == null) {
            return null;
        }
        if (index < 0) {
            index = chainTrace.traces.size() - 1;
        }
        return ((ChainTraces)this.tracesCache.getIfPresent((Object)key)).getTrace(index);
    }

    public Trace getLastErrorTrace() {
        return this.lastError;
    }

    public void clearTrace(OperationChain chain, int index) {
        ((ChainTraces)this.tracesCache.getIfPresent((Object)chain)).removeTrace(index);
    }

    public void clearTrace(OperationChain chain) {
        this.tracesCache.invalidate((Object)chain);
    }

    @Override
    public void clearTraces() {
        this.tracesCache.invalidateAll();
    }

    protected static String formatKey(OperationType chain, int index) {
        return String.format("%s:%s", chain.getId(), index);
    }

    public void onTrace(Trace popped) {
        this.recordTrace(popped);
    }

    @Override
    public boolean toggleRecording() {
        this.recording = !this.recording;
        return this.recording;
    }

    @Override
    public boolean getRecordingState() {
        return this.recording;
    }

    @Override
    public String getPrintableTraces() {
        return this.printableTraces;
    }

    @Override
    public String setPrintableTraces(String printableTraces) {
        this.printableTraces = printableTraces;
        return printableTraces;
    }

    protected static class ChainTraces {
        protected OperationType chain;
        protected Map<Integer, Trace> traces = new HashMap<Integer, Trace>();

        protected ChainTraces(OperationType chain) {
            this.chain = chain;
        }

        protected String add(Trace trace) {
            int index = this.traces.size();
            this.traces.put(index, trace);
            return TracerFactory.formatKey(trace.chain, index);
        }

        protected Trace getTrace(int index) {
            return this.traces.get(index);
        }

        protected void removeTrace(int index) {
            this.traces.remove(index);
        }

        protected void clear() {
            this.traces.clear();
        }
    }
}

