/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private List<String> _contentText;
    private String _type;
    private String _src;

    public Content() {
    }

    public Content(String contentText) {
        this._contentText = new ArrayList<String>();
        this._contentText.add(contentText);
        this._type = "text";
    }

    public Content addContentText(String contentText) {
        this._contentText = this._contentText != null ? this._contentText : new ArrayList<String>();
        this._contentText.add(contentText);
        return this;
    }

    public List<String> getContentText() {
        return this._contentText;
    }

    public Content setContentText(List<String> contentText) {
        this._contentText = contentText;
        return this;
    }

    public String getSrc() {
        return this._src;
    }

    public Content setSrc(String src) {
        this._src = src;
        return this;
    }

    public String getType() {
        return this._type;
    }

    public Content setType(String type) {
        this._type = type;
        return this;
    }

    public Content setOtherAttributes(Map<QName, String> otherAttributes) {
        this._otherAttributes = otherAttributes;
        return this;
    }

    public Content addOtherAttributes(QName namespace, String attribute) {
        if (this._otherAttributes == null) {
            this._otherAttributes = new HashMap();
        }
        this._otherAttributes.put(namespace, attribute);
        return this;
    }

    public Content setOtherElements(List<Element> otherElements) {
        this._otherElements = otherElements;
        return this;
    }

    public Content addOtherElement(Element element) {
        if (this._otherElements == null) {
            this._otherElements = new ArrayList();
        }
        this._otherElements.add(element);
        return this;
    }

    public Content addOtherElement(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        return this.addOtherElement(XMLUtils.parseXml(xmlString, false, false).getDocumentElement());
    }

    public Content setBase(String base) {
        this._base = base;
        return this;
    }

    public Content setLang(String lang) {
        this._lang = lang;
        return this;
    }

    public Content setLang(Locale lang) {
        this._lang = lang.getLanguage();
        return this;
    }

    @Override
    public void validate(FeedFormat format) throws ValidationException {
    }
}

