/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem;

public abstract class ReferenceHandler {
    public static final String PREFIX_DOWNLOAD = "download:";
    public static final String PREFIX_IMAGE = "image:";

    public void handle(String ref) {
        ref = ref.trim();
        int idx = ref.indexOf(32);
        String label = "";
        if (idx > 0) {
            label = ref.substring(idx).trim();
            ref = ref.substring(0, idx);
        }
        if (ref.startsWith(PREFIX_IMAGE)) {
            ref = ref.substring(PREFIX_IMAGE.length());
            if (label == null || "".equals(label)) {
                label = ref;
            }
            this.handleImage(ref, label);
        } else if (ref.startsWith(PREFIX_DOWNLOAD)) {
            ref = ref.substring(PREFIX_DOWNLOAD.length());
            if (label == null || "".equals(label)) {
                label = ref;
            }
            this.handleDownload(ref, label);
        } else {
            if (label == null || "".equals(label)) {
                label = ref;
            }
            this.handleReference(ref, label);
        }
    }

    protected void handleDownload(String ref, String label) {
        this.handleReference(ref, label);
    }

    protected abstract void handleImage(String var1, String var2);

    protected abstract void handleReference(String var1, String var2);
}

