/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.IIntIDFactory;
import com.phloc.commons.idfactory.IStringIDFactory;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public class StringIDFromIntIDFactory
implements IStringIDFactory {
    private final IIntIDFactory m_aIntIDFactory;
    private final String m_sPrefix;

    public StringIDFromIntIDFactory(@Nonnull IIntIDFactory iIntIDFactory) {
        this(iIntIDFactory, "id");
    }

    public StringIDFromIntIDFactory(@Nonnull IIntIDFactory iIntIDFactory, @Nonnull String string) {
        if (iIntIDFactory == null) {
            throw new NullPointerException("intIDFactory");
        }
        if (string == null) {
            throw new NullPointerException("prefix");
        }
        this.m_aIntIDFactory = iIntIDFactory;
        this.m_sPrefix = string;
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public String getNewID() {
        return this.m_sPrefix + Integer.toString(this.m_aIntIDFactory.getNewID());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StringIDFromIntIDFactory)) {
            return false;
        }
        StringIDFromIntIDFactory stringIDFromIntIDFactory = (StringIDFromIntIDFactory)object;
        return this.m_aIntIDFactory.equals(stringIDFromIntIDFactory.m_aIntIDFactory) && this.m_sPrefix.equals(stringIDFromIntIDFactory.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aIntIDFactory).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("intIDFactory", this.m_aIntIDFactory).append("prefix", this.m_sPrefix).toString();
    }
}

