/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.iterate;

import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.collections.iterate.IterableIterator;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.filter.collections.FilterIterator;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.filter.FileFilterToIFilterAdapter;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileSystemIterator
extends IterableIterator<File> {
    public FileSystemIterator(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemIterator(@Nonnull File file) {
        super(FileUtils.getDirectoryContent(file));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, @Nonnull FilenameFilter filenameFilter) {
        return new FilterIterator<File>(new FileSystemIterator(string), (IFilter<File>)new FileFilterToIFilterAdapter(filenameFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, @Nonnull FilenameFilter filenameFilter) {
        return new FilterIterator<File>(new FileSystemIterator(file), (IFilter<File>)new FileFilterToIFilterAdapter(filenameFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, FilenameFilter ... filenameFilterArray) {
        return new FilterIterator<File>(new FileSystemIterator(string), FileFilterToIFilterAdapter.getANDChained(filenameFilterArray));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, FilenameFilter ... filenameFilterArray) {
        return new FilterIterator<File>(new FileSystemIterator(file), FileFilterToIFilterAdapter.getANDChained(filenameFilterArray));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, @Nonnull FileFilter fileFilter) {
        return new FilterIterator<File>(new FileSystemIterator(string), (IFilter<File>)new FileFilterToIFilterAdapter(fileFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, @Nonnull FileFilter fileFilter) {
        return new FilterIterator<File>(new FileSystemIterator(file), (IFilter<File>)new FileFilterToIFilterAdapter(fileFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, FileFilter ... fileFilterArray) {
        return new FilterIterator<File>(new FileSystemIterator(string), FileFilterToIFilterAdapter.getANDChained(fileFilterArray));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, FileFilter ... fileFilterArray) {
        return new FilterIterator<File>(new FileSystemIterator(file), FileFilterToIFilterAdapter.getANDChained(fileFilterArray));
    }
}

