/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.system;

import com.phloc.commons.system.EJVMVendor;
import com.phloc.commons.system.EJavaVersion;
import com.phloc.commons.system.EOperatingSystem;
import com.phloc.commons.system.EProcessorArchitecture;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SystemHelper {
    private static final int s_nNumberOfProcessors = Runtime.getRuntime().availableProcessors();
    private static final SystemHelper s_aInstance = new SystemHelper();

    private SystemHelper() {
    }

    @Nonnegative
    public static int getNumberOfProcessors() {
        return s_nNumberOfProcessors;
    }

    @Nonnull
    public static EProcessorArchitecture getProcessorArchitecture() {
        return EProcessorArchitecture.getCurrentArchitecture();
    }

    @Nonnull
    public static EOperatingSystem getOperatingSystem() {
        return EOperatingSystem.getCurrentOS();
    }

    @Nonnull
    public static String getOperatingSystemName() {
        return EOperatingSystem.getCurrentOSName() + " [" + EOperatingSystem.getCurrentOSVersion() + "]";
    }

    @Nonnull
    public static EJavaVersion getJavaVersion() {
        return EJavaVersion.getCurrentVersion();
    }

    @Nonnull
    public static EJVMVendor getJVMVendor() {
        return EJVMVendor.getCurrentVendor();
    }

    @Nonnull
    public static Locale getSystemLocale() {
        return Locale.getDefault();
    }

    @Nonnull
    public static Charset getSystemCharset() {
        return Charset.defaultCharset();
    }

    @Nonnull
    public static String getSystemCharsetName() {
        return SystemHelper.getSystemCharset().name();
    }

    @Nonnegative
    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    @Nonnegative
    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @Nonnegative
    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }
}

