/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.xml.CXML;
import com.phloc.commons.xml.ChildElementIterator;
import com.phloc.commons.xml.EXMLIncorrectCharacterHandling;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.FilterElementWithNamespace;
import com.phloc.commons.xml.FilterElementWithNamespaceAndLocalName;
import com.phloc.commons.xml.FilterElementWithTagName;
import com.phloc.commons.xml.FilterElementWithoutNamespace;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Immutable
public final class XMLHelper {
    private static final char[] MASK_PATTERNS_XML10 = new char[]{'\u0000', '&', '<', '>', '\"', '\''};
    private static final char[] MASK_PATTERNS_CONTROL = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\u000b', '\f', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u2028'};
    private static final char[] MASK_PATTERNS_ALL = ArrayHelper.getConcatenated(MASK_PATTERNS_XML10, MASK_PATTERNS_CONTROL);
    private static final char[][] MASK_REPLACE_XML10 = new char[][]{"".toCharArray(), "&amp;".toCharArray(), "&lt;".toCharArray(), "&gt;".toCharArray(), "&quot;".toCharArray(), "&#39;".toCharArray()};
    private static final char[][] MASK_REPLACE_CONTROL_EMPTY = new char[][]{"".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "\n".toCharArray()};
    private static final char[][] MASK_REPLACE_ALL_EMPTY = ArrayHelper.getConcatenated(MASK_REPLACE_XML10, MASK_REPLACE_CONTROL_EMPTY);
    private static final char[][] MASK_REPLACE_CONTROL_XML11 = new char[][]{"&#1;".toCharArray(), "&#2;".toCharArray(), "&#3;".toCharArray(), "&#4;".toCharArray(), "&#5;".toCharArray(), "&#6;".toCharArray(), "&#7;".toCharArray(), "&#8;".toCharArray(), "&#11;".toCharArray(), "&#12;".toCharArray(), "&#14;".toCharArray(), "&#15;".toCharArray(), "&#16;".toCharArray(), "&#17;".toCharArray(), "&#18;".toCharArray(), "&#19;".toCharArray(), "&#20;".toCharArray(), "&#21;".toCharArray(), "&#22;".toCharArray(), "&#23;".toCharArray(), "&#24;".toCharArray(), "&#25;".toCharArray(), "&#26;".toCharArray(), "&#27;".toCharArray(), "&#28;".toCharArray(), "&#29;".toCharArray(), "&#30;".toCharArray(), "&#31;".toCharArray(), "&#2028;".toCharArray()};
    private static final char[][] MASK_REPLACE_ALL_XML11 = ArrayHelper.getConcatenated(MASK_REPLACE_XML10, MASK_REPLACE_CONTROL_XML11);
    private static final boolean[] ILLEGAL_XML_CHARS = new boolean[]{true, true, true, true, true, true, true, true, true, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final XMLHelper s_aInstance;

    private XMLHelper() {
    }

    @Nullable
    public static Element getFirstChildElement(@Nonnull Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            return (Element)node2;
        }
        return null;
    }

    public static boolean hasChildElementNodes(@Nonnull Node node) {
        return XMLHelper.getFirstChildElement(node) != null;
    }

    @Nullable
    public static Element getFirstChildElementOfName(@Nonnull Node node, @Nullable String string) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !(element = (Element)node2).getTagName().equals(string)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public static Document getOwnerDocument(@Nullable Node node) {
        return node == null ? null : (node instanceof Document ? (Document)node : node.getOwnerDocument());
    }

    @Nonnull
    public static Node append(@Nonnull Node node, @Nullable Object object) {
        if (node == null) {
            throw new NullPointerException("parentNode");
        }
        if (object != null) {
            if (object instanceof Document) {
                XMLHelper.append(node, ((Document)object).getDocumentElement());
            } else if (object instanceof Node) {
                Node node2 = (Node)object;
                Document document = XMLHelper.getOwnerDocument(node);
                if (XMLHelper.getOwnerDocument(node2).equals(document)) {
                    node.appendChild(node2);
                } else {
                    node.appendChild(document.adoptNode(node2.cloneNode(true)));
                }
            } else if (object instanceof String) {
                node.appendChild(XMLHelper.getOwnerDocument(node).createTextNode((String)object));
            } else if (object instanceof Iterable) {
                for (Object t : (Iterable)object) {
                    XMLHelper.append(node, t);
                }
            } else if (ArrayHelper.isArray(object)) {
                for (Object object2 : (Object[])object) {
                    XMLHelper.append(node, object2);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to a DOMNode (type=" + object.getClass().getName() + ".");
            }
        }
        return node;
    }

    public static void append(@Nonnull Node node, @Nonnull Collection<?> collection) {
        for (Object obj : collection) {
            XMLHelper.append(node, obj);
        }
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element) {
        return element == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element));
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element, @Nonnull @Nonempty String string) {
        return element == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string) {
        return element == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string, @Nonnull @Nonempty String string2) {
        return element == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string, string2));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nonnull Node node) {
        return new ChildElementIterator(node, FilterElementWithoutNamespace.getInstance());
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nonnull Node node, @Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("Passed tag name is illegal");
        }
        return new ChildElementIterator(node, new FilterElementWithTagName(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nonnull Node node, @Nullable String string) {
        return new ChildElementIterator(node, new FilterElementWithNamespace(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nonnull Node node, @Nullable String string, @Nonnull @Nonempty String string2) {
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("Passed local name is illegal");
        }
        return new ChildElementIterator(node, new FilterElementWithNamespaceAndLocalName(string, string2));
    }

    public static boolean hasNamespaceURI(@Nullable Node node, @Nullable String string) {
        String string2 = node == null ? null : node.getNamespaceURI();
        return string2 != null && string2.equals(string);
    }

    @Nonnull
    public static String getPathToNode(@Nonnull Node node) {
        return XMLHelper.getPathToNode(node, "/");
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static String getPathToNode(@Nonnull Node node, @Nonnull String string) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (string == null) {
            throw new NullPointerException("separator");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            StringBuilder stringBuilder2 = new StringBuilder(node2.getNodeName());
            if (node2.getNodeType() == 1 && node2.getParentNode() != null) {
                Element element;
                Element element2 = (Element)node2;
                int n = 0;
                Iterator iterator = XMLHelper.getChildElementIteratorNoNS(node2.getParentNode()).iterator();
                while (iterator.hasNext() && (element = (Element)iterator.next()) != node2) {
                    if (!element.getTagName().equals(element2.getTagName())) continue;
                    ++n;
                }
                stringBuilder2.append('[').append(n).append(']');
            }
            stringBuilder.insert(0, string).insert(0, stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public static void removeAllChildElements(@Nonnull Element element) {
        while (element.getChildNodes().getLength() > 0) {
            element.removeChild(element.getChildNodes().item(0));
        }
    }

    @Nonnull
    public static char[] getMaskedXMLText(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nullable String string) {
        char[] cArray;
        if (eXMLIncorrectCharacterHandling.isTestRequired() && string != null && XMLHelper.containsInvalidXMLCharacter(cArray = string.toCharArray())) {
            eXMLIncorrectCharacterHandling.notifyOnInvalidXMLCharacter(string, XMLHelper.getAllInvalidXMLCharacters(cArray));
            if (eXMLIncorrectCharacterHandling.isReplaceWithNothing()) {
                return StringHelper.replaceMultiple(string, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_EMPTY);
            }
        }
        if (eXMLVersion.equals((Object)EXMLVersion.XML_10)) {
            return StringHelper.replaceMultiple(string, MASK_PATTERNS_XML10, MASK_REPLACE_XML10);
        }
        return StringHelper.replaceMultiple(string, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_XML11);
    }

    @Nonnegative
    public static int getMaskedXMLTextLength(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        if (eXMLIncorrectCharacterHandling.isTestRequired() && XMLHelper.containsInvalidXMLCharacter(cArray)) {
            eXMLIncorrectCharacterHandling.notifyOnInvalidXMLCharacter(string, XMLHelper.getAllInvalidXMLCharacters(cArray));
            if (eXMLIncorrectCharacterHandling.isReplaceWithNothing()) {
                int n = StringHelper.getReplaceMultipleResultLength(cArray, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_EMPTY);
                return n == -1 ? string.length() : n;
            }
        }
        int n = eXMLVersion.equals((Object)EXMLVersion.XML_10) ? StringHelper.getReplaceMultipleResultLength(cArray, MASK_PATTERNS_XML10, MASK_REPLACE_XML10) : StringHelper.getReplaceMultipleResultLength(cArray, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_XML11);
        return n == -1 ? string.length() : n;
    }

    public static void maskXMLTextTo(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nullable String string, @Nonnull Writer writer) throws IOException {
        char[] cArray;
        if (eXMLIncorrectCharacterHandling.isTestRequired() && string != null && XMLHelper.containsInvalidXMLCharacter(cArray = string.toCharArray())) {
            eXMLIncorrectCharacterHandling.notifyOnInvalidXMLCharacter(string, XMLHelper.getAllInvalidXMLCharacters(cArray));
            if (eXMLIncorrectCharacterHandling.isReplaceWithNothing()) {
                StringHelper.replaceMultipleTo(string, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_EMPTY, writer);
                return;
            }
        }
        if (eXMLVersion.equals((Object)EXMLVersion.XML_10)) {
            StringHelper.replaceMultipleTo(string, MASK_PATTERNS_XML10, MASK_REPLACE_XML10, writer);
        } else {
            StringHelper.replaceMultipleTo(string, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_XML11, writer);
        }
    }

    public static boolean isTextNode(@Nullable Node node) {
        return node instanceof CharacterData && !(node instanceof Comment) || node instanceof EntityReference;
    }

    @Nullable
    public static String getFirstChildText(@Nullable Node node) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Text text;
                Node node2 = nodeList.item(i);
                if (!(node2 instanceof Text) || (text = (Text)node2).isElementContentWhitespace()) continue;
                return text.getData();
            }
        }
        return null;
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nonnull String string) {
        return XMLHelper.getAttributeValue(element, string, null);
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nonnull String string, @Nullable String string2) {
        Attr attr = element.getAttributeNode(string);
        return attr == null ? string2 : attr.getValue();
    }

    @Nullable
    public static Map<String, String> getAllAttributesAsMap(@Nullable Element element) {
        NamedNodeMap namedNodeMap;
        if (element != null && (namedNodeMap = element.getAttributes()) != null) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(namedNodeMap.getLength());
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                linkedHashMap.put(attr.getName(), attr.getValue());
            }
            return linkedHashMap;
        }
        return null;
    }

    @Nonnull
    public static String getXMLNSPrefix(@Nonnull String string) {
        if (StringHelper.hasNoText(string) || string.contains(CXML.XML_PREFIX_NAMESPACE_SEP_STR)) {
            throw new IllegalArgumentException("prefix is invalid: " + string);
        }
        return "xmlns:" + string;
    }

    @Nullable
    public static String getNamespaceURI(@Nullable Node node) {
        if (node instanceof Document) {
            return XMLHelper.getNamespaceURI(((Document)node).getDocumentElement());
        }
        if (node != null) {
            return node.getNamespaceURI();
        }
        return null;
    }

    public static boolean isInvalidXMLCharacter(char c) {
        if (c < '\u0100') {
            return ILLEGAL_XML_CHARS[c];
        }
        return c == '\u2028' || c >= '\ufdd0' && c <= '\ufddf' || c == '\ufffe' || c == '\uffff' || Character.isHighSurrogate(c) || Character.isLowSurrogate(c);
    }

    public static boolean containsInvalidXMLCharacter(@Nullable String string) {
        return string == null ? false : XMLHelper.containsInvalidXMLCharacter(string.toCharArray());
    }

    public static boolean containsInvalidXMLCharacter(@Nullable char[] cArray) {
        if (cArray != null) {
            for (char c : cArray) {
                if (!XMLHelper.isInvalidXMLCharacter(c)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Set<Character> getAllInvalidXMLCharacters(@Nullable String string) {
        return string == null ? null : XMLHelper.getAllInvalidXMLCharacters(string.toCharArray());
    }

    @Nullable
    public static Set<Character> getAllInvalidXMLCharacters(@Nullable char[] cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return null;
        }
        HashSet<Character> hashSet = new HashSet<Character>();
        for (char c : cArray) {
            if (!XMLHelper.isInvalidXMLCharacter(c)) continue;
            hashSet.add(Character.valueOf(c));
        }
        return hashSet;
    }

    @Nonnegative
    public static int getLength(@Nullable NodeList nodeList) {
        return nodeList == null ? 0 : nodeList.getLength();
    }

    public static boolean isEmpty(@Nullable NodeList nodeList) {
        return XMLHelper.getLength(nodeList) == 0;
    }

    static {
        if (MASK_PATTERNS_XML10.length != MASK_REPLACE_XML10.length) {
            throw new IllegalStateException("Regular arrays have different length!");
        }
        if (MASK_PATTERNS_CONTROL.length != MASK_REPLACE_CONTROL_EMPTY.length) {
            throw new IllegalStateException("Empty arrays have different length!");
        }
        if (MASK_PATTERNS_CONTROL.length != MASK_REPLACE_CONTROL_XML11.length) {
            throw new IllegalStateException("Control arrays have different length!");
        }
        if (MASK_PATTERNS_ALL.length != MASK_REPLACE_ALL_EMPTY.length) {
            throw new IllegalStateException("Empty arrays have different length!");
        }
        if (MASK_PATTERNS_ALL.length != MASK_REPLACE_ALL_XML11.length) {
            throw new IllegalStateException("Overall arrays have different length!");
        }
        s_aInstance = new XMLHelper();
    }
}

