/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.reader;

import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.handler.CSSHandler;
import com.phloc.css.handler.DoNothingCSSParseExceptionHandler;
import com.phloc.css.handler.ICSSParseExceptionHandler;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.CharStream;
import com.phloc.css.parser.JavaCharStream;
import com.phloc.css.parser.ParseException;
import com.phloc.css.parser.ParserCSS21;
import com.phloc.css.parser.ParserCSS21TokenManager;
import com.phloc.css.parser.ParserCSS30;
import com.phloc.css.parser.ParserCSS30TokenManager;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSReaderDeclarationList {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReaderDeclarationList.class);

    private CSSReaderDeclarationList() {
    }

    @Nullable
    private static CSSNode _readStyleDeclaration(@Nonnull CharStream charStream, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        switch (eCSSVersion) {
            case CSS21: {
                ParserCSS21TokenManager parserCSS21TokenManager = new ParserCSS21TokenManager(charStream);
                ParserCSS21 parserCSS21 = new ParserCSS21(parserCSS21TokenManager);
                try {
                    return parserCSS21.styleDeclaration();
                }
                catch (ParseException parseException) {
                    if (iCSSParseExceptionHandler != null) {
                        iCSSParseExceptionHandler.onException(parseException);
                    } else {
                        s_aLogger.error("Failed to parse CSS 2.1 style declaration: " + parseException.getMessage());
                    }
                    return null;
                }
            }
            case CSS30: {
                ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
                ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
                try {
                    return parserCSS30.styleDeclaration();
                }
                catch (ParseException parseException) {
                    if (iCSSParseExceptionHandler != null) {
                        iCSSParseExceptionHandler.onException(parseException);
                    } else {
                        s_aLogger.error("Failed to parse CSS 3.0 style declaration: " + parseException.getMessage());
                    }
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eCSSVersion));
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(file), string, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(file), charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        Charset charset = CharsetManager.getCharsetFromName((String)string);
        return CSSReaderDeclarationList.isValidCSS(iReadableResource, charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        if (iReadableResource == null) {
            throw new NullPointerException("resources");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (eCSSVersion == null) {
            throw new NullPointerException("version");
        }
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            s_aLogger.warn("Failed to open CSS reader " + iReadableResource);
            return false;
        }
        return CSSReaderDeclarationList.isValidCSS(reader, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (string == null) {
            throw new NullPointerException("charset");
        }
        return CSSReaderDeclarationList.isValidCSS(StreamUtils.createReader((InputStream)inputStream, (String)string), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        return CSSReaderDeclarationList.isValidCSS(StreamUtils.createReader((InputStream)inputStream, (Charset)charset), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        if (string == null) {
            throw new NullPointerException("reader");
        }
        return CSSReaderDeclarationList.isValidCSS((Reader)new NonBlockingStringReader(string), eCSSVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        if (eCSSVersion == null) {
            throw new NullPointerException("version");
        }
        try {
            JavaCharStream javaCharStream = new JavaCharStream(reader);
            CSSNode cSSNode = CSSReaderDeclarationList._readStyleDeclaration(javaCharStream, eCSSVersion, new DoNothingCSSParseExceptionHandler());
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamUtils.close((Closeable)reader);
        }
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), eCSSVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromFile(file, string, eCSSVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromFile(file, charset, eCSSVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(string), eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromStream(iInputStreamProvider, string, eCSSVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromStream(iInputStreamProvider, charset, eCSSVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        if (iInputStreamProvider == null) {
            throw new NullPointerException("inputStreamProvider");
        }
        InputStream inputStream = iInputStreamProvider.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromReader(StreamUtils.createReader((InputStream)inputStream, (String)string), eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        if (iInputStreamProvider == null) {
            throw new NullPointerException("inputStreamProvider");
        }
        InputStream inputStream = iInputStreamProvider.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromReader(StreamUtils.createReader((InputStream)inputStream, (Charset)charset), eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader(reader, eCSSVersion, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        if (eCSSVersion == null) {
            throw new NullPointerException("version");
        }
        try {
            JavaCharStream javaCharStream = new JavaCharStream(reader);
            CSSNode cSSNode = CSSReaderDeclarationList._readStyleDeclaration(javaCharStream, eCSSVersion, iCSSParseExceptionHandler);
            if (cSSNode == null) {
                CSSDeclarationList cSSDeclarationList = null;
                return cSSDeclarationList;
            }
            CSSDeclarationList cSSDeclarationList = CSSHandler.readDeclarationListFromNode(eCSSVersion, cSSNode);
            return cSSDeclarationList;
        }
        finally {
            StreamUtils.close((Closeable)reader);
        }
    }
}

