/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import org.apache.geronimo.connector.ResourceAdapterWrapper;

public class ActivationSpecWrapper {
    protected final ActivationSpec activationSpec;
    private final ResourceAdapterWrapper resourceAdapterWrapper;
    private final String containerId;

    public ActivationSpecWrapper() {
        this.activationSpec = null;
        this.containerId = null;
        this.resourceAdapterWrapper = null;
    }

    public ActivationSpecWrapper(String activationSpecClass, String containerId, ResourceAdapterWrapper resourceAdapterWrapper, ClassLoader cl) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = cl.loadClass(activationSpecClass);
        this.activationSpec = (ActivationSpec)clazz.newInstance();
        this.containerId = containerId;
        this.resourceAdapterWrapper = resourceAdapterWrapper;
    }

    public ActivationSpecWrapper(ActivationSpec activationSpec, ResourceAdapterWrapper resourceAdapterWrapper) {
        this.activationSpec = activationSpec;
        this.resourceAdapterWrapper = resourceAdapterWrapper;
        this.containerId = null;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public ResourceAdapterWrapper getResourceAdapterWrapper() {
        return this.resourceAdapterWrapper;
    }

    public void activate(MessageEndpointFactory messageEndpointFactory) throws ResourceException {
        ResourceAdapter resourceAdapter = this.activationSpec.getResourceAdapter();
        if (resourceAdapter == null) {
            this.resourceAdapterWrapper.registerResourceAdapterAssociation((ResourceAdapterAssociation)this.activationSpec);
        }
        this.resourceAdapterWrapper.endpointActivation(messageEndpointFactory, this.activationSpec);
        this.resourceAdapterWrapper.doRecovery(this.activationSpec, this.containerId);
    }

    public void deactivate(MessageEndpointFactory messageEndpointFactory) {
        ResourceAdapter resourceAdapter = this.activationSpec.getResourceAdapter();
        if (resourceAdapter == null) {
            throw new IllegalStateException("ActivationSpec was never registered with ResourceAdapter");
        }
        this.resourceAdapterWrapper.deregisterRecovery(this.containerId);
        this.resourceAdapterWrapper.endpointDeactivation(messageEndpointFactory, this.activationSpec);
    }
}

