/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api.query;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.audit.api.query.AuditQueryException;

public final class DateRangeParser {
    private DateRangeParser() {
    }

    public static Date parseDateRangeQuery(Date now, String dateRangeQuery) throws AuditQueryException {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            if (dateRangeQuery != null) {
                Map<String, Integer> parsed = DateRangeParser.parseQuery(dateRangeQuery);
                if (parsed.containsKey("h")) {
                    calendar.add(11, -parsed.get("h").intValue());
                }
                if (parsed.containsKey("m")) {
                    calendar.add(12, -parsed.get("m").intValue());
                }
            }
            return calendar.getTime();
        }
        catch (NumberFormatException nfe) {
            throw new AuditQueryException("Invalid query format...", nfe);
        }
    }

    private static Map<String, Integer> parseQuery(String query) throws AuditQueryException {
        String sub;
        HashMap<String, Integer> parsed = new HashMap<String, Integer>();
        query = query.trim();
        query = query.replace(" ", "");
        int offsetMinutes = query.indexOf("m");
        int offsetHours = query.indexOf("h");
        if (offsetMinutes != -1) {
            sub = query.substring(0, offsetMinutes);
            try {
                parsed.put("m", Integer.parseInt(sub));
            }
            catch (NumberFormatException nfe) {
                throw new AuditQueryException(nfe.getMessage(), nfe);
            }
        }
        if (offsetHours != -1) {
            sub = offsetMinutes == -1 ? query.substring(0, offsetHours) : query.substring(offsetMinutes + 1, offsetHours);
            try {
                parsed.put("h", Integer.parseInt(sub));
            }
            catch (NumberFormatException nfe) {
                throw new AuditQueryException(nfe.getMessage(), nfe);
            }
        }
        return parsed;
    }
}

