/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;

public class BasicAuthenticator
implements NuxeoAuthenticationPlugin {
    protected static final String REALM_NAME_KEY = "RealmName";
    protected static final String FORCE_PROMPT_KEY = "ForcePromptURL";
    protected static final String AUTO_PROMPT_KEY = "AutoPrompt";
    protected static final String PROMPT_URL_KEY = "PromptUrl";
    protected static final String DEFAULT_REALMNAME = "Nuxeo 5";
    protected static final String BA_HEADER_NAME = "WWW-Authenticate";
    protected String realName;
    protected Boolean autoPrompt = false;
    protected List<String> forcePromptURLs;

    @Override
    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        try {
            String baHeader = "Basic realm=\"" + this.realName + '\"';
            httpResponse.addHeader(BA_HEADER_NAME, baHeader);
            httpResponse.sendError(401);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String auth = httpRequest.getHeader("authorization");
        if (auth != null && auth.toLowerCase().startsWith("basic")) {
            int idx = auth.indexOf(32);
            String b64userPassword = auth.substring(idx + 1);
            byte[] clearUp = Base64.decode((String)b64userPassword);
            String userCredentials = new String(clearUp);
            int idxOfColon = userCredentials.indexOf(58);
            if (idxOfColon > 0 && idxOfColon < userCredentials.length() - 1) {
                String username = userCredentials.substring(0, idxOfColon);
                String password = userCredentials.substring(idxOfColon + 1);
                return new UserIdentificationInfo(username, password);
            }
            return null;
        }
        return null;
    }

    @Override
    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        if (this.autoPrompt.booleanValue()) {
            return true;
        }
        String requestedURI = httpRequest.getRequestURI();
        String context = httpRequest.getContextPath() + '/';
        requestedURI = requestedURI.substring(context.length());
        for (String prefixURL : this.forcePromptURLs) {
            if (!requestedURI.startsWith(prefixURL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initPlugin(Map<String, String> parameters) {
        this.realName = parameters.containsKey(REALM_NAME_KEY) ? parameters.get(REALM_NAME_KEY) : DEFAULT_REALMNAME;
        if (parameters.containsKey(AUTO_PROMPT_KEY)) {
            this.autoPrompt = parameters.get(AUTO_PROMPT_KEY).equalsIgnoreCase("true");
        }
        this.forcePromptURLs = new ArrayList<String>();
        for (String key : parameters.keySet()) {
            if (!key.startsWith(FORCE_PROMPT_KEY)) continue;
            this.forcePromptURLs.add(parameters.get(key));
        }
    }

    @Override
    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }
}

