/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DataModelMap;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DataModelMapImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public class SimpleDocumentModel
implements DocumentModel {
    private static final long serialVersionUID = 1L;
    protected final boolean anySchema;
    protected final DataModelMap dataModels = new DataModelMapImpl();
    protected Set<String> schemas;
    protected final ScopedMap contextData = new ScopedMap();
    protected Path path;
    protected String type;

    public SimpleDocumentModel(List<String> schemas) {
        this.schemas = new HashSet<String>();
        this.anySchema = false;
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        for (String schema : schemas) {
            Schema s = schemaManager.getSchema(schema);
            DocumentPartImpl part = new DocumentPartImpl(s);
            this.dataModels.put(schema, new DataModelImpl(part));
            this.schemas.add(schema);
        }
    }

    public SimpleDocumentModel(String ... schemas) {
        this(Arrays.asList(schemas));
    }

    public SimpleDocumentModel() {
        this.schemas = new HashSet<String>();
        this.anySchema = true;
    }

    protected DataModel getDataModelInternal(String schema) {
        DataModel dm = (DataModel)this.dataModels.get(schema);
        if (dm == null && this.anySchema) {
            SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
            Schema s = schemaManager.getSchema(schema);
            DocumentPartImpl part = new DocumentPartImpl(s);
            dm = new DataModelImpl(part);
            this.dataModels.put(schema, dm);
            this.schemas.add(schema);
        }
        return dm;
    }

    @Override
    public String[] getSchemas() {
        Set keys = this.dataModels.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public String[] getDeclaredSchemas() {
        return this.getSchemas();
    }

    @Override
    public Object getProperty(String schemaName, String name) throws ClientException {
        DataModel dm = this.getDataModelInternal(schemaName);
        return dm != null ? dm.getData(name) : null;
    }

    @Override
    public void setProperty(String schemaName, String name, Object value) throws ClientException {
        if (name.contains(":")) {
            name = name.substring(name.indexOf(":"), name.length());
        }
        this.getDataModelInternal(schemaName).setData(name, value);
    }

    @Override
    public Map<String, Object> getProperties(String schemaName) throws ClientException {
        return this.getDataModelInternal(schemaName).getMap();
    }

    @Override
    public void setProperties(String schemaName, Map<String, Object> data) throws ClientException {
        this.getDataModelInternal(schemaName).setMap(data);
    }

    @Override
    public ScopedMap getContextData() {
        return this.contextData;
    }

    @Override
    public Serializable getContextData(ScopeType scope, String key) {
        return this.contextData.getScopedValue(scope, key);
    }

    @Override
    public void putContextData(ScopeType scope, String key, Serializable value) {
        this.contextData.putScopedValue(scope, key, value);
    }

    @Override
    public Serializable getContextData(String key) {
        return this.contextData.getScopedValue(key);
    }

    @Override
    public void putContextData(String key, Serializable value) {
        this.contextData.putScopedValue(key, value);
    }

    @Override
    public void copyContextData(DocumentModel otherDocument) {
        ScopedMap otherMap = otherDocument.getContextData();
        if (otherMap != null) {
            this.contextData.putAll((Map)otherMap);
        }
    }

    @Override
    public Property getProperty(String xpath) throws PropertyException, ClientException {
        if (xpath == null) {
            throw new PropertyNotFoundException("null", "Invalid null xpath");
        }
        String cxpath = ComplexTypeImpl.canonicalXPath((String)xpath);
        if (cxpath.isEmpty()) {
            throw new PropertyNotFoundException(xpath, "Schema not specified");
        }
        String schemaName = DocumentModelImpl.getXPathSchemaName(cxpath, this.schemas, null);
        if (schemaName == null) {
            if (cxpath.indexOf(58) != -1) {
                throw new PropertyNotFoundException(xpath, "No such schema");
            }
            throw new PropertyNotFoundException(xpath);
        }
        DocumentPart part = this.getPart(schemaName);
        if (part == null) {
            throw new PropertyNotFoundException(xpath);
        }
        String partPath = cxpath.substring(cxpath.indexOf(58) + 1);
        try {
            return part.resolvePath(partPath);
        }
        catch (PropertyNotFoundException e) {
            throw new PropertyNotFoundException(xpath, e.getDetail());
        }
    }

    @Override
    public Serializable getPropertyValue(String xpath) throws PropertyException, ClientException {
        return this.getProperty(xpath).getValue();
    }

    @Override
    public void setPropertyValue(String xpath, Serializable value) throws ClientException {
        this.getProperty(xpath).setValue(value);
    }

    @Override
    public DocumentType getDocumentType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSessionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CoreSession getCoreSession() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void detach(boolean loadAll) {
    }

    @Override
    public void attach(String sid) {
    }

    @Override
    public DocumentRef getRef() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentRef getParentRef() {
        if (this.path == null) {
            return null;
        }
        if (!this.path.isAbsolute()) {
            return null;
        }
        return new PathRef(this.path.removeLastSegments(1).toString());
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.path == null ? null : this.path.lastSegment();
    }

    @Override
    public Long getPos() {
        return null;
    }

    @Override
    public String getPathAsString() {
        return this.path == null ? null : this.path.toString();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public String getTitle() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Set<String> getFacets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getDeclaredFacets() {
        return this.getFacets();
    }

    @Override
    public Collection<DataModel> getDataModelsCollection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataModelMap getDataModels() {
        return this.dataModels;
    }

    @Override
    public DataModel getDataModel(String schema) throws ClientException {
        return this.getDataModelInternal(schema);
    }

    @Override
    public void setPathInfo(String parentPath, String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocked() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLock(String key) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unlock() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock setLock() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock getLockInfo() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock removeLock() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ACP getACP() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setACP(ACP acp, boolean overwrite) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSchema(String schema) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasFacet(String facet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addFacet(String facet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFacet(String facet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFolder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVersionable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDownloadable() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProxy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isImmutable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDirty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(PropertyVisitor visitor, Object arg) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getAdapter(Class<T> itf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getAdapter(Class<T> itf, boolean refreshCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCurrentLifeCycleState() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLifeCyclePolicy() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean followTransition(String transition) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> getAllowedStateTransitions() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyContent(DocumentModel sourceDoc) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRepositoryName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCacheKey() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourceId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVersionLabel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCheckinComment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrefetched(String xpath) {
        return false;
    }

    @Override
    public boolean isPrefetched(String schemaName, String name) {
        return false;
    }

    @Override
    public void prefetchCurrentLifecycleState(String lifecycle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void prefetchLifeCyclePolicy(String lifeCyclePolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLifeCycleLoaded() {
        return false;
    }

    @Override
    public <T extends Serializable> T getSystemProp(String systemProperty, Class<T> type) throws ClientException, DocumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentPart getPart(String schema) throws ClientException {
        DataModel dm = this.getDataModel(schema);
        if (dm != null) {
            return ((DataModelImpl)dm).getDocumentPart();
        }
        return null;
    }

    @Override
    public DocumentPart[] getParts() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(int refreshFlags, String[] schemas) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCheckedOut() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkOut() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentRef checkIn(VersioningOption option, String description) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVersionSeriesId() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLatestVersion() throws ClientException {
        return false;
    }

    @Override
    public boolean isMajorVersion() throws ClientException {
        return false;
    }

    @Override
    public boolean isLatestMajorVersion() throws ClientException {
        return false;
    }

    @Override
    public boolean isVersionSeriesCheckedOut() throws ClientException {
        return true;
    }

    @Override
    public String getChangeToken() {
        return null;
    }

    @Override
    public Map<String, String> getBinaryFulltext() throws ClientException {
        return null;
    }

    @Deprecated
    public static class SimpleDataModel
    implements DataModel {
        private static final long serialVersionUID = 1L;
        public final String schema;
        public final Map<String, Object> data = new HashMap<String, Object>();

        public SimpleDataModel(String schema) {
            this.schema = schema;
        }

        @Override
        public void setData(String key, Object value) throws PropertyException {
            this.data.put(key, value);
        }

        @Override
        public Object getData(String key) throws PropertyException {
            return this.data.get(key);
        }

        @Override
        public String getSchema() {
            return this.schema;
        }

        @Override
        public Map<String, Object> getMap() throws PropertyException {
            return this.data;
        }

        @Override
        public void setMap(Map<String, Object> data) throws PropertyException {
            data = new HashMap<String, Object>(data);
        }

        @Override
        public boolean isDirty() {
            return true;
        }

        @Override
        public boolean isDirty(String name) throws PropertyNotFoundException {
            return true;
        }

        @Override
        public void setDirty(String name) throws PropertyNotFoundException {
        }

        @Override
        public Collection<String> getDirtyFields() {
            return this.data.keySet();
        }

        @Override
        public Object getValue(String path) throws PropertyException {
            throw new UnsupportedOperationException("getValue");
        }

        @Override
        public Object setValue(String path, Object value) throws PropertyException {
            throw new UnsupportedOperationException("setValue");
        }
    }
}

