/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;

public class PDShadingType4
extends PDShadingResources {
    private COSArray decode = null;

    public PDShadingType4(COSDictionary shadingDictionary) {
        super(shadingDictionary);
    }

    public int getShadingType() {
        return 4;
    }

    public int getBitsPerComponent() {
        return this.getCOSDictionary().getInt(COSName.BITS_PER_COMPONENT, -1);
    }

    public void setBitsPerComponent(int bpc) {
        this.getCOSDictionary().setInt(COSName.BITS_PER_COMPONENT, bpc);
    }

    public int getBitsPerCoordinate() {
        return this.getCOSDictionary().getInt(COSName.BITS_PER_COORDINATE, -1);
    }

    public void setBitsPerCoordinate(int bpc) {
        this.getCOSDictionary().setInt(COSName.BITS_PER_COORDINATE, bpc);
    }

    public int getBitsPerFlag() {
        return this.getCOSDictionary().getInt(COSName.BITS_PER_FLAG, -1);
    }

    public void setBitsPerFlag(int bpf) {
        this.getCOSDictionary().setInt(COSName.BITS_PER_FLAG, bpf);
    }

    private COSArray getDecodeValues() {
        if (this.decode == null) {
            this.decode = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.DECODE);
        }
        return this.decode;
    }

    public void setDecodeValues(COSArray decodeValues) {
        this.decode = decodeValues;
        this.getCOSDictionary().setItem(COSName.DECODE, (COSBase)decodeValues);
    }

    public PDRange getDecodeForParameter(int paramNum) {
        PDRange retval = null;
        COSArray decodeValues = this.getDecodeValues();
        if (decodeValues != null && decodeValues.size() >= paramNum * 2 + 1) {
            retval = new PDRange(decodeValues, paramNum);
        }
        return retval;
    }
}

