/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.DocumentXMLExporter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.TypedSingleDocumentReader;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDocumentWriter;
import org.xml.sax.InputSource;

public class DocumentXMLExporterImpl
implements DocumentXMLExporter {
    private static final long serialVersionUID = 4086449614391137730L;

    @Override
    public InputStream exportXML(DocumentModel doc, CoreSession session) throws ClientException {
        byte[] xmlExportByteArray = this.exportXMLAsByteArray(doc, session);
        return new ByteArrayInputStream(xmlExportByteArray);
    }

    @Override
    public InputSource exportXMLAsInputSource(DocumentModel doc, CoreSession session) throws ClientException {
        InputStream xmlExportInputStream = this.exportXML(doc, session);
        return new InputSource(xmlExportInputStream);
    }

    @Override
    public final byte[] exportXMLAsByteArray(DocumentModel doc, CoreSession session) throws ClientException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLDocumentWriter documentWriter = new XMLDocumentWriter(outputStream);
        TypedSingleDocumentReader documentReader = new TypedSingleDocumentReader(session, doc);
        DocumentPipeImpl pipe = new DocumentPipeImpl();
        pipe.setReader(documentReader);
        pipe.setWriter(documentWriter);
        try {
            pipe.run();
        }
        catch (Exception e) {
            throw new ClientException("Error while trying to export the document to XML.", (Throwable)e);
        }
        finally {
            if (documentReader != null) {
                documentReader.close();
            }
            if (documentWriter != null) {
                documentWriter.close();
            }
        }
        return outputStream.toByteArray();
    }
}

