/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.shared.CallContextHandler;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStreamFactory;

public abstract class AbstractCmisHttpServlet
extends HttpServlet {
    public static final String PARAM_CALL_CONTEXT_HANDLER = "callContextHandler";
    public static final String PARAM_CMIS_VERSION = "cmisVersion";
    private static final long serialVersionUID = 1L;
    private CmisServiceFactory factory;
    private String binding;
    private CmisVersion cmisVersion;
    private CallContextHandler callContextHandler;
    private ThresholdOutputStreamFactory streamFactory;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.callContextHandler = null;
        String callContextHandlerClass = config.getInitParameter(PARAM_CALL_CONTEXT_HANDLER);
        if (callContextHandlerClass != null) {
            try {
                this.callContextHandler = (CallContextHandler)ClassLoaderUtil.loadClass((String)callContextHandlerClass).newInstance();
            }
            catch (Exception e) {
                throw new ServletException("Could not load call context handler: " + e, (Throwable)e);
            }
        }
        this.factory = (CmisServiceFactory)config.getServletContext().getAttribute("org.apache.chemistry.opencmis.servicesfactory");
        if (this.factory == null) {
            throw new CmisRuntimeException("Service factory not available! Configuration problem?");
        }
        this.streamFactory = ThresholdOutputStreamFactory.newInstance(this.factory.getTempDirectory(), this.factory.getMemoryThreshold(), this.factory.getMaxContentSize(), this.factory.encryptTempFiles());
    }

    protected void setBinding(String binding) {
        this.binding = binding;
    }

    protected CmisVersion getCmisVersion() {
        return this.cmisVersion;
    }

    protected void setCmisVersion(CmisVersion cmisVersion) {
        this.cmisVersion = cmisVersion;
    }

    protected CmisServiceFactory getServiceFactory() {
        return this.factory;
    }

    protected CallContextHandler getCallContextHandler() {
        return this.callContextHandler;
    }

    protected ThresholdOutputStreamFactory getThresholdOutputStreamFactory() {
        return this.streamFactory;
    }

    protected CallContext createContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        Map<String, String> callContextMap;
        String[] pathFragments = HttpUtils.splitPath(request);
        String repositoryId = null;
        if (pathFragments.length > 0) {
            repositoryId = pathFragments[0];
        }
        CallContextImpl context = null;
        context = "browser".equals(this.binding) ? new BrowserCallContextImpl(this.binding, this.cmisVersion, repositoryId, servletContext, request, response, this.factory, this.streamFactory) : new CallContextImpl(this.binding, this.cmisVersion, repositoryId, servletContext, request, response, this.factory, this.streamFactory);
        context.setRange(request.getHeader("Range"));
        context.setAcceptLanguage(request.getHeader("Accept-Language"));
        if (this.callContextHandler != null && (callContextMap = this.callContextHandler.getCallContextMap(request)) != null) {
            for (Map.Entry<String, String> e : callContextMap.entrySet()) {
                context.put(e.getKey(), e.getValue());
            }
        }
        return context;
    }
}

