/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.EventTransactionListener;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.AsyncEventExecutor;
import org.nuxeo.ecm.core.event.impl.AsyncWaitHook;
import org.nuxeo.ecm.core.event.impl.EventBundleImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventListenerList;
import org.nuxeo.ecm.core.event.impl.PostCommitEventExecutor;
import org.nuxeo.ecm.core.event.impl.ShallowEvent;
import org.nuxeo.ecm.core.event.jms.AsyncProcessorConfig;
import org.nuxeo.runtime.api.Framework;

public class EventServiceImpl
implements EventService,
EventServiceAdmin {
    public static final VMID VMID = new VMID();
    private static final Log log = LogFactory.getLog(EventServiceImpl.class);
    protected static final ThreadLocal<CompositeEventBundle> compositeBundle = new ThreadLocal<CompositeEventBundle>(){

        @Override
        protected CompositeEventBundle initialValue() {
            return new CompositeEventBundle();
        }
    };
    protected final ListenerList txListeners;
    protected final EventListenerList listenerDescriptors;
    protected PostCommitEventExecutor postCommitExec;
    protected volatile AsyncEventExecutor asyncExec;
    protected final List<AsyncWaitHook> asyncWaitHooks = new CopyOnWriteArrayList<AsyncWaitHook>();
    protected boolean blockAsyncProcessing = false;
    protected boolean blockSyncPostCommitProcessing = false;
    protected boolean bulkModeEnabled = false;

    public EventServiceImpl() {
        this.txListeners = new ListenerList();
        this.listenerDescriptors = new EventListenerList();
        this.postCommitExec = new PostCommitEventExecutor();
        this.asyncExec = new AsyncEventExecutor();
        this.init();
    }

    public void init() {
        this.asyncExec.init();
    }

    public void shutdown(long timeoutMillis) throws InterruptedException {
        this.postCommitExec.shutdown(timeoutMillis);
        HashSet<AsyncWaitHook> notTerminated = new HashSet<AsyncWaitHook>();
        for (AsyncWaitHook hook : this.asyncWaitHooks) {
            if (hook.shutdown()) continue;
            notTerminated.add(hook);
        }
        if (!notTerminated.isEmpty()) {
            throw new RuntimeException("Asynch services are still running : " + notTerminated);
        }
        if (!this.asyncExec.shutdown(timeoutMillis)) {
            throw new RuntimeException("Async executor is still running, timeout expired");
        }
    }

    public void registerForAsyncWait(AsyncWaitHook callback) {
        this.asyncWaitHooks.add(callback);
    }

    public void unregisterForAsyncWait(AsyncWaitHook callback) {
        this.asyncWaitHooks.remove(callback);
    }

    @Deprecated
    public int getActiveAsyncTaskCount() {
        return this.asyncExec.getUnfinishedCount();
    }

    @Override
    public void waitForAsyncCompletion() {
        this.waitForAsyncCompletion(Long.MAX_VALUE);
    }

    @Override
    public void waitForAsyncCompletion(long timeout) {
        HashSet<AsyncWaitHook> notCompleted = new HashSet<AsyncWaitHook>();
        for (AsyncWaitHook hook : this.asyncWaitHooks) {
            if (hook.waitForAsyncCompletion()) continue;
            notCompleted.add(hook);
        }
        if (!notCompleted.isEmpty()) {
            throw new RuntimeException("Async tasks are still running : " + notCompleted);
        }
        try {
            if (!this.asyncExec.waitForCompletion(timeout)) {
                throw new RuntimeException("Async event listeners thread pool is not terminated");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addEventListener(EventListenerDescriptor listener) {
        try {
            this.listenerDescriptors.add(listener);
            log.debug((Object)("Registered event listener: " + listener.getName()));
        }
        catch (Exception e) {
            log.error((Object)("Failed to register event listener: " + listener.getName()), (Throwable)e);
        }
    }

    @Override
    public void removeEventListener(EventListenerDescriptor listener) {
        try {
            this.listenerDescriptors.removeDescriptor(listener);
            log.debug((Object)("Unregistered event listener: " + listener.getName()));
        }
        catch (Exception e) {
            log.error((Object)("Failed to unregister event listener: " + listener.getName()), (Throwable)e);
        }
    }

    protected EventStats getEventStats() {
        try {
            return (EventStats)Framework.getService(EventStats.class);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to lookup event stats service", (Throwable)e);
            return null;
        }
    }

    @Override
    public void fireEvent(String name, EventContext context) throws ClientException {
        this.fireEvent(new EventImpl(name, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(Event event) throws ClientException {
        String ename = event.getName();
        EventStats stats = this.getEventStats();
        for (EventListenerDescriptor desc : this.listenerDescriptors.getEnabledInlineListenersDescriptors()) {
            Throwable rollbackException;
            block28: {
                if (!desc.acceptEvent(ename)) continue;
                rollbackException = null;
                try {
                    long t0 = System.currentTimeMillis();
                    desc.asEventListener().handleEvent(event);
                    if (stats != null) {
                        stats.logSyncExec(desc, System.currentTimeMillis() - t0);
                    }
                    if (!event.isBubbleException()) break block28;
                }
                catch (Throwable t) {
                    block29: {
                        try {
                            String message;
                            if (event.isBubbleException() || event.isMarkedForRollBack()) {
                                message = "Error during " + desc.getName() + " sync listener execution, transaction will be rolled back";
                                rollbackException = t;
                            } else {
                                message = "Error during " + desc.getName() + " sync listener execution, transaction won't be rolled back " + "since event.markRollBack() was not called by the Listener";
                            }
                            if (t instanceof RecoverableClientException) {
                                log.info((Object)(message + "\n" + t.getMessage()));
                                log.debug((Object)message, t);
                            } else {
                                log.error((Object)message, t);
                            }
                            if (!event.isBubbleException()) break block29;
                        }
                        catch (Throwable throwable) {
                            if (event.isBubbleException()) {
                                throw new RuntimeException(rollbackException);
                            }
                            if (event.isMarkedForRollBack()) {
                                String message = "Exception during " + desc.getName() + " sync listener execution, rolling back";
                                if (event.getRollbackMessage() != null) {
                                    message = message + " (" + event.getRollbackMessage() + ")";
                                }
                                if (event.getRollbackException() != null) {
                                    rollbackException = event.getRollbackException();
                                }
                                if (rollbackException != null) {
                                    throw new RuntimeException(message, rollbackException);
                                }
                                throw new RuntimeException(message);
                            }
                            if (event.isCanceled()) {
                                return;
                            }
                            throw throwable;
                        }
                        throw new RuntimeException(rollbackException);
                    }
                    if (event.isMarkedForRollBack()) {
                        String message = "Exception during " + desc.getName() + " sync listener execution, rolling back";
                        if (event.getRollbackMessage() != null) {
                            message = message + " (" + event.getRollbackMessage() + ")";
                        }
                        if (event.getRollbackException() != null) {
                            rollbackException = event.getRollbackException();
                        }
                        if (rollbackException != null) {
                            throw new RuntimeException(message, rollbackException);
                        }
                        throw new RuntimeException(message);
                    }
                    if (!event.isCanceled()) continue;
                    return;
                }
                throw new RuntimeException(rollbackException);
            }
            if (event.isMarkedForRollBack()) {
                String message = "Exception during " + desc.getName() + " sync listener execution, rolling back";
                if (event.getRollbackMessage() != null) {
                    message = message + " (" + event.getRollbackMessage() + ")";
                }
                if (event.getRollbackException() != null) {
                    rollbackException = event.getRollbackException();
                }
                if (rollbackException != null) {
                    throw new RuntimeException(message, rollbackException);
                }
                throw new RuntimeException(message);
            }
            if (!event.isCanceled()) continue;
            return;
        }
        if (!event.isInline()) {
            Object b;
            ShallowEvent shallowEvent = ShallowEvent.create(event);
            if (event.isImmediate()) {
                b = new EventBundleImpl();
                ((EventBundleImpl)b).push(shallowEvent);
                this.fireEventBundle((EventBundle)b);
            } else {
                b = compositeBundle.get();
                ((CompositeEventBundle)b).push(shallowEvent);
                if (!((CompositeEventBundle)b).transacted && event.isCommitEvent()) {
                    this.handleTxCommited();
                }
            }
        }
    }

    @Override
    public void fireEventBundle(EventBundle event) throws ClientException {
        boolean comesFromJMS = false;
        if (event instanceof ReconnectedEventBundle && ((ReconnectedEventBundle)event).comesFromJMS()) {
            comesFromJMS = true;
        }
        List<EventListenerDescriptor> postCommitSync = this.listenerDescriptors.getEnabledSyncPostCommitListenersDescriptors();
        List<EventListenerDescriptor> postCommitAsync = this.listenerDescriptors.getEnabledAsyncPostCommitListenersDescriptors();
        if (this.bulkModeEnabled) {
            List<Object> listeners = new ArrayList();
            if (!this.blockSyncPostCommitProcessing) {
                listeners = postCommitSync;
            }
            if (!this.blockAsyncProcessing) {
                listeners.addAll(postCommitAsync);
            }
            if (!listeners.isEmpty()) {
                this.postCommitExec.runBulk(listeners, event);
            }
            return;
        }
        if (this.blockSyncPostCommitProcessing) {
            log.debug((Object)"Dropping PostCommit handler execution");
        } else if (comesFromJMS) {
            log.debug((Object)"Deactivating sync post-commit listener since we are called from JMS");
        } else if (!postCommitSync.isEmpty()) {
            this.postCommitExec.run(postCommitSync, event);
        }
        if (this.blockAsyncProcessing) {
            log.debug((Object)"Dopping bundle");
            return;
        }
        if (AsyncProcessorConfig.forceJMSUsage() && !comesFromJMS) {
            log.debug((Object)"Skipping async exec, this will be triggered via JMS");
        } else {
            this.asyncExec.run(postCommitAsync, event);
        }
    }

    @Override
    public void fireEventBundleSync(EventBundle event) throws ClientException {
        for (EventListenerDescriptor desc : this.listenerDescriptors.getEnabledSyncPostCommitListenersDescriptors()) {
            desc.asPostCommitListener().handleEvent(event);
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getEnabledAsyncPostCommitListenersDescriptors()) {
            desc.asPostCommitListener().handleEvent(event);
        }
    }

    @Override
    public List<EventListener> getEventListeners() {
        return this.listenerDescriptors.getInLineListeners();
    }

    @Override
    public List<PostCommitEventListener> getPostCommitEventListeners() {
        ArrayList<PostCommitEventListener> result = new ArrayList<PostCommitEventListener>();
        result.addAll(this.listenerDescriptors.getSyncPostCommitListeners());
        result.addAll(this.listenerDescriptors.getAsyncPostCommitListeners());
        return result;
    }

    @Override
    public void transactionStarted() {
        this.handleTxStarted();
    }

    @Override
    public void transactionCommitted() throws ClientException {
        this.handleTxCommited();
    }

    @Override
    public void transactionRolledback() {
        this.handleTxRollbacked();
    }

    @Override
    public boolean isTransactionStarted() {
        return EventServiceImpl.compositeBundle.get().transacted;
    }

    public EventListenerList getEventListenerList() {
        return this.listenerDescriptors;
    }

    @Override
    public EventListenerDescriptor getEventListener(String name) {
        return this.listenerDescriptors.getDescriptor(name);
    }

    @Override
    public EventListenerList getListenerList() {
        return this.listenerDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListenerEnabledFlag(String listenerName, boolean enabled) {
        if (!this.listenerDescriptors.hasListener(listenerName)) {
            return;
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getAsyncPostCommitListenersDescriptors()) {
            if (!desc.getName().equals(listenerName)) continue;
            desc.setEnabled(enabled);
            EventServiceImpl eventServiceImpl = this;
            synchronized (eventServiceImpl) {
                this.listenerDescriptors.recomputeEnabledListeners();
            }
            return;
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getSyncPostCommitListenersDescriptors()) {
            if (!desc.getName().equals(listenerName)) continue;
            desc.setEnabled(enabled);
            EventServiceImpl eventServiceImpl = this;
            synchronized (eventServiceImpl) {
                this.listenerDescriptors.recomputeEnabledListeners();
            }
            return;
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getInlineListenersDescriptors()) {
            if (!desc.getName().equals(listenerName)) continue;
            desc.setEnabled(enabled);
            EventServiceImpl eventServiceImpl = this;
            synchronized (eventServiceImpl) {
                this.listenerDescriptors.recomputeEnabledListeners();
            }
            return;
        }
    }

    @Override
    public int getActiveThreadsCount() {
        return this.asyncExec.getActiveCount();
    }

    @Override
    public int getEventsInQueueCount() {
        return this.asyncExec.getUnfinishedCount();
    }

    @Override
    public boolean isBlockAsyncHandlers() {
        return this.blockAsyncProcessing;
    }

    @Override
    public boolean isBlockSyncPostCommitHandlers() {
        return this.blockSyncPostCommitProcessing;
    }

    @Override
    public void setBlockAsyncHandlers(boolean blockAsyncHandlers) {
        this.blockAsyncProcessing = blockAsyncHandlers;
    }

    @Override
    public void setBlockSyncPostCommitHandlers(boolean blockSyncPostComitHandlers) {
        this.blockSyncPostCommitProcessing = blockSyncPostComitHandlers;
    }

    @Override
    public boolean isBulkModeEnabled() {
        return this.bulkModeEnabled;
    }

    @Override
    public void setBulkModeEnabled(boolean bulkModeEnabled) {
        this.bulkModeEnabled = bulkModeEnabled;
    }

    @Override
    public void addTransactionListener(EventTransactionListener listener) {
        this.txListeners.add((Object)listener);
    }

    @Override
    public void removeTransactionListener(EventTransactionListener listener) {
        this.txListeners.remove((Object)listener);
    }

    protected void handleTxStarted() {
        EventServiceImpl.compositeBundle.get().transacted = true;
        for (Object listener : this.txListeners.getListeners()) {
            ((EventTransactionListener)listener).transactionStarted();
        }
    }

    protected void handleTxRollbacked() {
        compositeBundle.remove();
        for (Object listener : this.txListeners.getListeners()) {
            ((EventTransactionListener)listener).transactionRollbacked();
        }
    }

    protected void handleTxCommited() {
        CompositeEventBundle b = compositeBundle.get();
        compositeBundle.remove();
        for (EventBundle bundle : b.byRepository.values()) {
            try {
                this.fireEventBundle(bundle);
            }
            catch (ClientException e) {
                log.error((Object)("Error while processing " + bundle), (Throwable)e);
            }
        }
        for (Object listener : this.txListeners.getListeners()) {
            ((EventTransactionListener)listener).transactionCommitted();
        }
    }

    private static class CompositeEventBundle {
        boolean transacted;
        final Map<String, EventBundle> byRepository = new HashMap<String, EventBundle>();

        private CompositeEventBundle() {
        }

        void push(Event event) {
            String repositoryName = event.getContext().getRepositoryName();
            if (!this.byRepository.containsKey(repositoryName)) {
                this.byRepository.put(repositoryName, new EventBundleImpl());
            }
            this.byRepository.get(repositoryName).push(event);
        }
    }
}

