/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.api;

import java.io.Serializable;
import javax.management.MXBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.api.Framework;

@MXBean
public class WorkSchedulePath
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final transient ThreadLocal<Work> enteredLocal = new ThreadLocal();
    public static final Log log = LogFactory.getLog(WorkSchedulePath.class);
    public static boolean capturePath = Boolean.parseBoolean(Framework.getProperty((String)"work.schedule.capturePath", (String)"true"));
    public static boolean captureStack = Boolean.parseBoolean(Framework.getProperty((String)"work.schedule.captureStack", (String)"false")) || log.isTraceEnabled();
    public static WorkSchedulePath EMPTY = new WorkSchedulePath();
    protected final String parentPath;
    protected final String name;
    protected final transient Trace scheduleStackTrace;

    public static void toggleCapturePath() {
        capturePath = !capturePath;
    }

    public static boolean isCapturePathEnabled() {
        return capturePath;
    }

    public static void toggleCaptureStack() {
        boolean bl = captureStack = !captureStack;
        if (captureStack) {
            capturePath = true;
        }
    }

    public static boolean isCaptureStackEnabled() {
        return capturePath && captureStack;
    }

    public static void newInstance(Work work) {
        if (!capturePath) {
            return;
        }
        Work entered = enteredLocal.get();
        WorkSchedulePath path = new WorkSchedulePath(entered == null ? EMPTY : entered.getSchedulePath(), work);
        work.setSchedulePath(path);
    }

    public static void handleEnter(Work work) {
        if (!capturePath) {
            return;
        }
        if (enteredLocal.get() != null) {
            throw new AssertionError((Object)"thread local leak, chain should not be re-rentrant");
        }
        enteredLocal.set(work);
    }

    public static void handleReturn() {
        if (!capturePath) {
            return;
        }
        enteredLocal.remove();
    }

    protected static String path(WorkSchedulePath parent) {
        if (EMPTY.equals(parent)) {
            return "";
        }
        return parent.parentPath + "/" + parent.name;
    }

    protected static String name(Work work) {
        return work.getCategory() + ":" + work.getId();
    }

    protected WorkSchedulePath() {
        this.parentPath = "";
        this.name = "";
        this.scheduleStackTrace = null;
    }

    protected WorkSchedulePath(WorkSchedulePath parent, Work work) {
        this.parentPath = parent.getPath();
        this.name = WorkSchedulePath.name(work);
        this.scheduleStackTrace = captureStack ? new Trace(parent.scheduleStackTrace) : null;
    }

    public String getPath() {
        return WorkSchedulePath.path(this);
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public Trace getStack() {
        return this.scheduleStackTrace;
    }

    public String toString() {
        return "[parentPath=" + this.parentPath + ", name=" + this.name + "]";
    }

    public class Trace
    extends Throwable {
        private static final long serialVersionUID = 1L;

        protected Trace(Trace cause) {
            super(WorkSchedulePath.this.getPath(), cause);
        }

        public WorkSchedulePath path() {
            return WorkSchedulePath.this;
        }
    }
}

