/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpSocket;

class HttpNotificationReceiver
extends GenericHttpNotificationReceiver {
    private int timeout = 60000;

    public HttpNotificationReceiver(GenericHttpConnectorClient connector, ClientNotificationDispatcher dispatcher) {
        super(2, 0, connector, dispatcher);
    }

    @Override
    GenericHttpSocket createSocket() {
        HttpSocket http_socket = new HttpSocket();
        http_socket.setTimeout(this.getTimeout());
        return http_socket;
    }

    @Override
    public String getProtocol() {
        return "http";
    }

    public int getTimeout() {
        if (this.sockListen != null) {
            return this.sockListen.getTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(int value) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.timeout = value;
        if (this.sockListen != null) {
            this.sockListen.setTimeout(value);
        }
    }

    @Override
    protected String makeDebugTag() {
        return "HttpNotificationReceiver[" + this.getProtocol() + ":" + this.getPort() + "]";
    }
}

