/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

abstract class NumericalBuiltins {
    NumericalBuiltins() {
    }

    static class cBI
    extends BuiltIn {
        cBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            Number num = EvaluationUtil.getNumber(model, this.target, env);
            if (num instanceof Integer) {
                return new SimpleScalar(num.toString());
            }
            return new SimpleScalar(env.getCNumberFormat().format(num));
        }
    }

    static class doubleBI
    extends NumberBuiltIn {
        doubleBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Double) {
                return model;
            }
            return new SimpleNumber(num.doubleValue());
        }
    }

    static class floatBI
    extends NumberBuiltIn {
        floatBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Float) {
                return model;
            }
            return new SimpleNumber(num.floatValue());
        }
    }

    static class longBI
    extends NumberBuiltIn {
        longBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Long) {
                return model;
            }
            return new SimpleNumber(num.longValue());
        }
    }

    static class intBI
    extends NumberBuiltIn {
        intBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Integer) {
                return model;
            }
            return new SimpleNumber(num.intValue());
        }
    }

    static class shortBI
    extends NumberBuiltIn {
        shortBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Short) {
                return model;
            }
            return new SimpleNumber(new Short(num.shortValue()));
        }
    }

    static class byteBI
    extends NumberBuiltIn {
        byteBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Byte) {
                return model;
            }
            return new SimpleNumber(new Byte(num.byteValue()));
        }
    }

    static abstract class NumberBuiltIn
    extends BuiltIn {
        NumberBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            return this.calculateResult(EvaluationUtil.getNumber(model, this.target, env), model);
        }

        abstract TemplateModel calculateResult(Number var1, TemplateModel var2);
    }
}

