/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.CachingBinaryManager;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class LazyBinary
extends Binary {
    private static final long serialVersionUID = 1L;
    protected boolean hasLength;
    protected transient CachingBinaryManager cbm;

    public LazyBinary(String digest, String repoName, CachingBinaryManager cbm) {
        super(digest, repoName);
        this.cbm = cbm;
    }

    protected CachingBinaryManager getCachingBinaryManager() {
        if (this.cbm == null) {
            if (this.repoName == null) {
                throw new UnsupportedOperationException("Cannot find binary manager, no repository name");
            }
            this.cbm = (CachingBinaryManager)RepositoryResolver.getBinaryManager(this.repoName);
        }
        return this.cbm;
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.file == null) {
            this.file = this.getCachingBinaryManager().getFile(this.digest);
            if (this.file != null) {
                this.length = this.file.length();
                this.hasLength = true;
            }
        }
        if (this.file == null) {
            return null;
        }
        return new FileInputStream(this.file);
    }

    @Override
    public StreamSource getStreamSource() {
        if (this.file == null) {
            try {
                this.file = this.getCachingBinaryManager().getFile(this.digest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.file != null) {
                this.length = this.file.length();
                this.hasLength = true;
            }
        }
        return this.file == null ? null : new FileSource(this.file);
    }

    @Override
    public long getLength() {
        if (!this.hasLength) {
            Long len;
            try {
                len = this.getCachingBinaryManager().getLength(this.digest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.length = len == null ? 0L : len;
            this.hasLength = true;
        }
        return this.length;
    }
}

