/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.filter;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingHttpServletResponse;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.RemoteHostGuessExtractor;
import org.nuxeo.ecm.platform.wi.backend.Backend;
import org.nuxeo.ecm.platform.wi.filter.WISession;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class WIRequestFilter
implements Filter {
    public static String WEBDAV_USERAGENT = "Microsoft-WebDAV-MiniRedir";
    public static String MSOFFICE_USERAGENT = "Microsoft Office Existence Discovery";
    public static final String SESSION_KEY = "org.nuxeo.ecm.platform.wi.session";
    public static final String BACKEND_KEY = "org.nuxeo.ecm.platform.wi.backend";
    public static final int LOCK_TIMOUT_S = 120;
    private static final Log log = LogFactory.getLog(WIRequestFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.isWIRequest(httpRequest) && httpRequest.getAttribute(SESSION_KEY) != null) {
            WISession session = new WISession(null);
            httpRequest.setAttribute(SESSION_KEY, (Object)session);
            boolean txStarted = false;
            try {
                txStarted = TransactionHelper.startTransaction();
                if (txStarted) {
                    response = new BufferingHttpServletResponse(httpResponse);
                }
                chain.doFilter(request, response);
                return;
            }
            catch (Exception e) {
                log.error((Object)this.doFormatLogMessage(httpRequest, "Unhandled error was cauth by the Filter"), (Throwable)e);
                if (!txStarted) throw new ServletException((Throwable)e);
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.doFormatLogMessage(httpRequest, "Marking transaction for RollBack"));
                }
                try {
                    TransactionHelper.setTransactionRollbackOnly();
                    throw new ServletException((Throwable)e);
                }
                catch (Exception e1) {
                    log.warn((Object)"Could not mark transaction as rollback only.");
                }
                throw new ServletException((Throwable)e);
            }
            finally {
                Backend backend;
                if (txStarted) {
                    try {
                        TransactionHelper.commitOrRollbackTransaction();
                    }
                    catch (TransactionRuntimeException e) {
                        ((HttpServletResponse)response).sendError(500, e.getMessage());
                        throw e;
                    }
                    finally {
                        ((BufferingHttpServletResponse)response).stopBuffering();
                    }
                }
                if ((backend = (Backend)session.getAttribute(BACKEND_KEY)) != null) {
                    backend.destroy();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.doFormatLogMessage(httpRequest, "Exiting NuxeoRequestControler filter"));
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean isWIRequest(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return StringUtils.isNotEmpty((String)ua) && (ua.contains(WEBDAV_USERAGENT) || ua.contains(MSOFFICE_USERAGENT));
    }

    protected String doFormatLogMessage(HttpServletRequest request, String info) {
        String remoteHost = RemoteHostGuessExtractor.getRemoteHost((HttpServletRequest)request);
        Principal principal = request.getUserPrincipal();
        String principalName = principal != null ? principal.getName() : "none";
        String uri = request.getRequestURI();
        String method = request.getMethod();
        HttpSession session = request.getSession(false);
        String sessionId = session != null ? session.getId() : "none";
        String threadName = Thread.currentThread().getName();
        return "remote=" + remoteHost + ",principal=" + principalName + ",uri=" + uri + ", method=" + method + ",session=" + sessionId + ",thread=" + threadName + ",info=" + info;
    }
}

