/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.runtime.api.Framework;

public final class ComponentUtils {
    public static final String WHITE_SPACE_CHARACTER = "&#x0020;";
    private static final Log log = LogFactory.getLog(ComponentUtils.class);
    private static final String VH_HEADER = "nuxeo-virtual-host";
    public static final String FORCE_NO_CACHE_ON_MSIE = "org.nuxeo.download.force.nocache.msie";

    private ComponentUtils() {
    }

    public static void encodeComponent(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        component.encodeChildren(context);
        component.encodeEnd(context);
    }

    public static void initiateSubComponent(UIComponent parent, String facetName, UIComponent child) {
        parent.getFacets().put(facetName, child);
        child.setRendered(false);
    }

    public static UIComponent hookSubComponent(FacesContext context, UIComponent parent, UIComponent child, String defaultChildId) {
        String childId = child.getId();
        if (defaultChildId != null) {
            childId = defaultChildId;
        }
        if (childId == null) {
            childId = context.getViewRoot().createUniqueId();
        }
        child.setId(childId);
        child.setParent(parent);
        child.setRendered(true);
        return child;
    }

    public static void copyValues(UIComponent parent, UIComponent child, String[] valueNames) {
        Map parentAttributes = parent.getAttributes();
        Map childAttributes = child.getAttributes();
        for (String name : valueNames) {
            ValueExpression ve;
            if (parentAttributes.containsKey(name)) {
                childAttributes.put(name, parentAttributes.get(name));
            }
            if ((ve = parent.getValueExpression(name)) == null) continue;
            child.setValueExpression(name, ve);
        }
    }

    public static void copyLinkValues(UIComponent parent, UIComponent child) {
        String[] valueNames = new String[]{"accesskey", "charset", "coords", "dir", "disabled", "hreflang", "lang", "onblur", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "rel", "rev", "shape", "style", "styleClass", "tabindex", "target", "title", "type"};
        ComponentUtils.copyValues(parent, child, valueNames);
    }

    public static Object getAttributeValue(UIComponent component, String attributeName, Object defaultValue) {
        Object value = component.getAttributes().get(attributeName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static Object getAttributeOrExpressionValue(FacesContext context, UIComponent component, String attributeName, Object defaultValue) {
        Object value = component.getAttributes().get(attributeName);
        if (value == null) {
            ValueExpression schemaExpr = component.getValueExpression(attributeName);
            value = schemaExpr.getValue(context.getELContext());
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String download(FacesContext faces, Blob blob, String filename) {
        if (!faces.getResponseComplete()) {
            ExternalContext econtext = faces.getExternalContext();
            Map map = econtext.getRequestParameterMap();
            if (map != null && map.containsKey("AJAXREQUEST")) {
                return null;
            }
            if (blob == null) {
                log.error((Object)("No bytes available for the file: " + filename));
            } else {
                HttpServletResponse response = (HttpServletResponse)econtext.getResponse();
                if (filename == null || filename.length() == 0) {
                    filename = "file";
                }
                HttpServletRequest request = (HttpServletRequest)econtext.getRequest();
                String digest = null;
                if (blob instanceof SQLBlob) {
                    digest = ((SQLBlob)blob).getBinary().getDigest();
                }
                try {
                    String previousToken = request.getHeader("If-None-Match");
                    if (previousToken != null && previousToken.equals(digest)) {
                        response.sendError(304);
                    } else {
                        response.setHeader("ETag", digest);
                        response.setHeader("Content-Disposition", ServletHelper.getRFC2231ContentDisposition((HttpServletRequest)request, (String)filename));
                        ComponentUtils.addCacheControlHeaders(request, response);
                        log.debug((Object)("Downloading with mime/type : " + blob.getMimeType()));
                        response.setContentType(blob.getMimeType());
                        long fileSize = blob.getLength();
                        if (fileSize > 0L) {
                            response.setContentLength((int)fileSize);
                        }
                        blob.transferTo((OutputStream)response.getOutputStream());
                        response.flushBuffer();
                    }
                }
                catch (IOException e) {
                    if (ExceptionHelper.isClientAbortError((Throwable)e)) {
                        ExceptionHelper.logClientAbort((Exception)e);
                    }
                    log.error((Object)("Error while downloading the file: " + filename), (Throwable)e);
                }
                faces.responseComplete();
            }
        }
        return null;
    }

    public static String downloadFile(FacesContext faces, String filename, File file) {
        FileBlob fileBlob = new FileBlob(file);
        return ComponentUtils.download(faces, (Blob)fileBlob, filename);
    }

    protected static boolean forceNoCacheOnMSIE() {
        return Framework.isBooleanPropertyTrue((String)FORCE_NO_CACHE_ON_MSIE);
    }

    private static void addCacheControlHeaders(HttpServletRequest request, HttpServletResponse response) {
        String nvh;
        String userAgent = request.getHeader("User-Agent");
        boolean secure = request.isSecure();
        if (!secure && (nvh = request.getHeader(VH_HEADER)) != null) {
            secure = nvh.startsWith("https");
        }
        log.debug((Object)("User-Agent: " + userAgent));
        log.debug((Object)("secure: " + secure));
        if (userAgent.contains("MSIE") && (secure || ComponentUtils.forceNoCacheOnMSIE())) {
            log.debug((Object)"Setting \"Cache-Control: max-age=15, must-revalidate\"");
            response.setHeader("Cache-Control", "max-age=15, must-revalidate");
        } else {
            log.debug((Object)"Setting \"Cache-Control: private\" and \"Pragma: no-cache\"");
            response.setHeader("Cache-Control", "private, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
    }

    public static String translate(FacesContext context, String messageId) {
        return ComponentUtils.translate(context, messageId, null);
    }

    public static String translate(FacesContext context, String messageId, Object ... params) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        return I18NUtils.getMessageString((String)bundleName, (String)messageId, (Object[])ComponentUtils.evaluateParams(context, params), (Locale)locale);
    }

    public static void addErrorMessage(FacesContext context, UIComponent component, String message) {
        ComponentUtils.addErrorMessage(context, component, message, null);
    }

    public static void addErrorMessage(FacesContext context, UIComponent component, String message, Object[] params) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        message = I18NUtils.getMessageString((String)bundleName, (String)message, (Object[])ComponentUtils.evaluateParams(context, params), (Locale)locale);
        FacesMessage msg = new FacesMessage(message);
        msg.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage(component.getClientId(context), msg);
    }

    protected static Object[] evaluateParams(FacesContext context, Object[] params) {
        if (params == null) {
            return null;
        }
        Object[] res = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object val = params[i];
            if (val instanceof String && ComponentTagUtils.isValueReference((String)val)) {
                ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), (String)val, Object.class);
                res[i] = ve.getValue(context.getELContext());
                continue;
            }
            res[i] = val;
        }
        return res;
    }

    public static UIComponent getBase(UIComponent anchor) {
        UIComponent base = anchor;
        boolean firstFound = false;
        while (base.getParent() != null) {
            if (base instanceof NamingContainer) {
                if (firstFound) break;
                firstFound = true;
            }
            base = base.getParent();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resolved base '%s' for anchor '%s'", base.getId(), anchor.getId()));
        }
        return base;
    }

    public static <T> T getComponent(UIComponent base, String componentId, Class<T> expectedComponentClass) {
        block6: {
            if (componentId == null) {
                log.error((Object)"Cannot retrieve component with a null id");
                return null;
            }
            try {
                UIComponent component = base.findComponent(componentId);
                if (component == null) {
                    log.error((Object)("Could not find component with id: " + componentId));
                    break block6;
                }
                try {
                    return (T)component;
                }
                catch (ClassCastException e) {
                    log.error((Object)String.format("Invalid component with id %s: %s, expected a component with interface %s", componentId, component, expectedComponentClass));
                }
            }
            catch (Exception e) {
                log.error((Object)("Error when trying to retrieve component with id " + componentId), (Throwable)e);
            }
        }
        return null;
    }

    static void clearTargetList(UIEditableList targetList) {
        int rc = targetList.getRowCount();
        for (int i = 0; i < rc; ++i) {
            targetList.removeValue(0);
        }
    }

    static void addToTargetList(UIEditableList targetList, SelectItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            targetList.addValue(items[i].getValue());
        }
    }

    public static void shiftItemsUp(UISelectMany targetSelect, UISelectItems targetItems, UIEditableList hiddenTargetList) {
        String[] selected = (String[])targetSelect.getSelectedValues();
        SelectItem[] all = (SelectItem[])targetItems.getValue();
        if (selected == null) {
            return;
        }
        ComponentUtils.shiftUp(selected, all);
        targetItems.setValue((Object)all);
        ComponentUtils.clearTargetList(hiddenTargetList);
        ComponentUtils.addToTargetList(hiddenTargetList, all);
    }

    public static void shiftItemsDown(UISelectMany targetSelect, UISelectItems targetItems, UIEditableList hiddenTargetList) {
        String[] selected = (String[])targetSelect.getSelectedValues();
        SelectItem[] all = (SelectItem[])targetItems.getValue();
        if (selected == null) {
            return;
        }
        ComponentUtils.shiftDown(selected, all);
        targetItems.setValue((Object)all);
        ComponentUtils.clearTargetList(hiddenTargetList);
        ComponentUtils.addToTargetList(hiddenTargetList, all);
    }

    public static void shiftItemsFirst(UISelectMany targetSelect, UISelectItems targetItems, UIEditableList hiddenTargetList) {
        String[] selected = (String[])targetSelect.getSelectedValues();
        SelectItem[] all = (SelectItem[])targetItems.getValue();
        if (selected == null) {
            return;
        }
        all = ComponentUtils.shiftFirst(selected, all);
        targetItems.setValue((Object)all);
        ComponentUtils.clearTargetList(hiddenTargetList);
        ComponentUtils.addToTargetList(hiddenTargetList, all);
    }

    public static void shiftItemsLast(UISelectMany targetSelect, UISelectItems targetItems, UIEditableList hiddenTargetList) {
        String[] selected = (String[])targetSelect.getSelectedValues();
        SelectItem[] all = (SelectItem[])targetItems.getValue();
        if (selected == null) {
            return;
        }
        all = ComponentUtils.shiftLast(selected, all);
        targetItems.setValue((Object)all);
        ComponentUtils.clearTargetList(hiddenTargetList);
        ComponentUtils.addToTargetList(hiddenTargetList, all);
    }

    static SelectItem[] shiftFirst(String[] selected, SelectItem[] all) {
        SelectItem[] res = new SelectItem[all.length];
        int sl = selected.length;
        int i = 0;
        int j = sl;
        for (SelectItem item : all) {
            if (i < sl && item.getValue().toString().equals(selected[i])) {
                res[i++] = item;
                continue;
            }
            res[j++] = item;
        }
        return res;
    }

    static SelectItem[] shiftLast(String[] selected, SelectItem[] all) {
        SelectItem[] res = new SelectItem[all.length];
        int sl = selected.length;
        int cut = all.length - sl;
        int i = 0;
        int j = 0;
        for (SelectItem item : all) {
            if (i < sl && item.getValue().toString().equals(selected[i])) {
                res[cut + i++] = item;
                continue;
            }
            res[j++] = item;
        }
        return res;
    }

    static void swap(Object[] ar, int i, int j) {
        Object t = ar[i];
        ar[i] = ar[j];
        ar[j] = t;
    }

    static void shiftUp(String[] selected, SelectItem[] all) {
        int pos = -1;
        for (int i = 0; i < selected.length; ++i) {
            String s = selected[i];
            int previous = pos;
            while (!all[++pos].getValue().equals(s)) {
            }
            if (pos <= previous + 1) continue;
            ComponentUtils.swap(all, pos--, pos);
        }
    }

    static void shiftDown(String[] selected, SelectItem[] all) {
        int pos = all.length;
        for (int i = selected.length - 1; i >= 0; --i) {
            String s = selected[i];
            int previous = pos;
            while (!all[--pos].getValue().equals(s)) {
            }
            if (pos >= previous - 1) continue;
            ComponentUtils.swap(all, pos++, pos);
        }
    }

    public static void moveItems(UISelectMany sourceSelect, UISelectItems sourceItems, UISelectItems targetItems, UIEditableList hiddenTargetList, boolean setTargetIds) {
        String[] selected = (String[])sourceSelect.getSelectedValues();
        if (selected == null) {
            return;
        }
        List<String> selectedList = Arrays.asList(selected);
        SelectItem[] all = (SelectItem[])sourceItems.getValue();
        ArrayList<SelectItem> toMove = new ArrayList<SelectItem>();
        ArrayList<SelectItem> toKeep = new ArrayList<SelectItem>();
        ArrayList<String> hiddenIds = new ArrayList<String>();
        if (all != null) {
            for (SelectItem item : all) {
                String itemId = item.getValue().toString();
                if (selectedList.contains(itemId)) {
                    toMove.add(item);
                    continue;
                }
                toKeep.add(item);
                if (setTargetIds) continue;
                hiddenIds.add(itemId);
            }
        }
        sourceItems.setValue((Object)toKeep.toArray(new SelectItem[0]));
        sourceSelect.setSelectedValues(new Object[0]);
        ArrayList<SelectItem> newSelectItems = new ArrayList<SelectItem>();
        SelectItem[] oldSelectItems = (SelectItem[])targetItems.getValue();
        if (oldSelectItems == null) {
            newSelectItems.addAll(toMove);
        } else {
            newSelectItems.addAll(Arrays.asList(oldSelectItems));
            ArrayList<String> oldIds = new ArrayList<String>();
            for (SelectItem oldItem : oldSelectItems) {
                String id = oldItem.getValue().toString();
                oldIds.add(id);
            }
            if (setTargetIds) {
                hiddenIds.addAll(0, oldIds);
            }
            for (SelectItem toMoveItem : toMove) {
                String id = toMoveItem.getValue().toString();
                if (oldIds.contains(id)) continue;
                newSelectItems.add(toMoveItem);
                if (!setTargetIds) continue;
                hiddenIds.add(id);
            }
        }
        targetItems.setValue((Object)newSelectItems.toArray(new SelectItem[0]));
        int numValues = hiddenTargetList.getRowCount();
        if (numValues > 0) {
            for (int i = numValues - 1; i > -1; --i) {
                hiddenTargetList.removeValue(i);
            }
        }
        for (String newHiddenValue : hiddenIds) {
            hiddenTargetList.addValue(newHiddenValue);
        }
    }

    public static void moveAllItems(UISelectItems sourceItems, UISelectItems targetItems, UIEditableList hiddenTargetList, boolean setTargetIds) {
        SelectItem[] all = (SelectItem[])sourceItems.getValue();
        ArrayList<SelectItem> toMove = new ArrayList<SelectItem>();
        ArrayList<SelectItem> toKeep = new ArrayList<SelectItem>();
        ArrayList hiddenIds = new ArrayList();
        if (all != null) {
            for (SelectItem item : all) {
                if (!item.isDisabled()) {
                    toMove.add(item);
                    continue;
                }
                toKeep.add(item);
            }
        }
        sourceItems.setValue((Object)toKeep.toArray(new SelectItem[0]));
        ArrayList<SelectItem> newSelectItems = new ArrayList<SelectItem>();
        SelectItem[] oldSelectItems = (SelectItem[])targetItems.getValue();
        if (oldSelectItems == null) {
            newSelectItems.addAll(toMove);
        } else {
            newSelectItems.addAll(Arrays.asList(oldSelectItems));
            ArrayList<String> oldIds = new ArrayList<String>();
            for (SelectItem oldItem : oldSelectItems) {
                String id = oldItem.getValue().toString();
                oldIds.add(id);
            }
            if (setTargetIds) {
                hiddenIds.addAll(0, oldIds);
            }
            for (SelectItem toMoveItem : toMove) {
                String id = toMoveItem.getValue().toString();
                if (oldIds.contains(id)) continue;
                newSelectItems.add(toMoveItem);
                if (!setTargetIds) continue;
                hiddenIds.add(id);
            }
        }
        targetItems.setValue((Object)newSelectItems.toArray(new SelectItem[0]));
        int numValues = hiddenTargetList.getRowCount();
        if (numValues > 0) {
            for (int i = numValues - 1; i > -1; --i) {
                hiddenTargetList.removeValue(i);
            }
        }
        for (String newHiddenValue : hiddenIds) {
            hiddenTargetList.addValue(newHiddenValue);
        }
    }
}

