/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io.documents;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;

@Provider
@Consumes(value={"application/json+nxentity", "application/json"})
public class JSONDocumentModelReader
implements MessageBodyReader<DocumentModel> {
    protected static final Log log = LogFactory.getLog(JSONDocumentModelReader.class);
    @Context
    HttpServletRequest request;
    @Context
    JsonFactory factory;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DocumentModel.class.isAssignableFrom(type);
    }

    public DocumentModel readFrom(Class<DocumentModel> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)entityStream);
        if (content.isEmpty() && content.isEmpty()) {
            throw new WebException("No content in request body", Response.Status.BAD_REQUEST.getStatusCode());
        }
        try {
            return this.readRequest(content, httpHeaders);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    private DocumentModel readRequest(String content, MultivaluedMap<String, String> httpHeaders) throws Exception {
        return this.readRequest(content, httpHeaders, this.request);
    }

    protected DocumentModel readRequest(String content, MultivaluedMap<String, String> httpHeaders, HttpServletRequest request) throws Exception {
        JsonParser jp = this.factory.createJsonParser(content);
        return JSONDocumentModelReader.readJson(jp, httpHeaders, request);
    }

    public static DocumentModel readJson(JsonParser jp, MultivaluedMap<String, String> httpHeaders, HttpServletRequest request) throws Exception {
        JsonToken tok = jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            tok = jp.nextToken();
        }
        SimpleDocumentModel tmp = new SimpleDocumentModel();
        String id = null;
        String type = null;
        String name = null;
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("uid".equals(key)) {
                id = (String)jp.readValueAs(String.class);
            } else if ("properties".equals(key)) {
                Properties props = JSONDocumentModelReader.readProperties(jp);
                DocumentHelper.setJSONProperties(null, (DocumentModel)tmp, (Properties)props);
            } else if ("name".equals(key)) {
                name = (String)jp.readValueAs(String.class);
            } else if ("type".equals(key)) {
                type = (String)jp.readValueAs(String.class);
            } else if ("entity-type".equals(key)) {
                String entityType = (String)jp.readValueAs(String.class);
                if (!"document".equals(entityType)) {
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            } else {
                log.debug((Object)("Unknown key: " + key));
                jp.skipChildren();
            }
            tok = jp.nextToken();
        }
        CoreSession session = SessionFactory.getSession((HttpServletRequest)request);
        DocumentModel doc = JSONDocumentModelReader.getOrCreateDocumentModel(id, type, name, session);
        JSONDocumentModelReader.applyPropertyValues((DocumentModel)tmp, doc);
        return doc;
    }

    private static void applyPropertyValues(DocumentModel src, DocumentModel dst) throws ClientException, PropertyException {
        for (String schema : src.getSchemas()) {
            DataModelImpl dataModel = (DataModelImpl)dst.getDataModel(schema);
            DataModel fromDataModel = src.getDataModel(schema);
            for (String field : fromDataModel.getDirtyFields()) {
                Serializable data = (Serializable)fromDataModel.getData(field);
                try {
                    if (!JSONDocumentModelReader.isNotNull(data)) continue;
                    if (!(dataModel.getDocumentPart().get(field) instanceof BlobProperty)) {
                        dataModel.setData(field, (Object)data);
                        continue;
                    }
                    dataModel.setData(field, (Object)JSONDocumentModelReader.decodeBlob(data));
                }
                catch (PropertyNotFoundException e) {
                    log.warn((Object)String.format("Trying to deserialize unexistent field : {%s}", field));
                }
            }
        }
    }

    private static Serializable decodeBlob(Serializable data) {
        if (data instanceof Blob) {
            return data;
        }
        return null;
    }

    private static boolean isNotNull(Serializable data) {
        return data != null && !"null".equals(data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DocumentModel getOrCreateDocumentModel(String id, String type, String name, CoreSession session) throws ClientException {
        DocumentModelImpl doc = null;
        if (StringUtils.isNotBlank((String)id)) {
            if (!session.exists((DocumentRef)new IdRef(id))) throw new WebApplicationException(Response.Status.NOT_FOUND);
            return session.getDocument((DocumentRef)new IdRef(id));
        }
        if (!StringUtils.isNotBlank((String)type)) throw new WebApplicationException(Response.Status.BAD_REQUEST);
        doc = DocumentModelFactory.createDocumentModel((String)type);
        if (!StringUtils.isNotBlank((String)name)) return doc;
        doc.setPathInfo(null, name);
        return doc;
    }

    static Properties readProperties(JsonParser jp) throws Exception {
        JsonNode node = jp.readValueAsTree();
        return new Properties(node);
    }
}

