/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.core.SortInfoDescriptor;
import org.nuxeo.ecm.platform.query.core.WhereClauseDescriptor;

@XObject(value="coreQueryPageProvider")
public class CoreQueryPageProviderDescriptor
implements PageProviderDefinition {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@enabled")
    protected boolean enabled = true;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> properties = new HashMap<String, String>();
    @XNodeList(value="parameter", type=String[].class, componentType=String.class)
    protected String[] queryParameters;
    @XNode(value="pageSize")
    protected long pageSize = 0L;
    @XNode(value="pageSizeBinding")
    protected String pageSizeBinding;
    @XNode(value="maxPageSize")
    protected Long maxPageSize;
    @XNodeList(value="pageSizeOptions/option", type=ArrayList.class, componentType=Long.class)
    protected List<Long> pageSizeOptions;
    @XNode(value="sortable")
    protected boolean sortable = true;
    @XNodeList(value="sort", type=ArrayList.class, componentType=SortInfoDescriptor.class)
    protected List<SortInfoDescriptor> sortInfos;
    @XNode(value="sortInfosBinding")
    protected String sortInfosBinding;
    protected String pattern;
    @XNode(value="pattern@quoteParameters")
    protected boolean quotePatternParameters = true;
    @XNode(value="pattern@escapeParameters")
    protected boolean escapePatternParameters = true;
    @XNode(value="whereClause")
    protected WhereClauseDescriptor whereClause;

    @Override
    @XNode(value="pattern")
    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern.replaceAll("\r?\n\\s*", " ");
        }
    }

    @Override
    public boolean getQuotePatternParameters() {
        return this.quotePatternParameters;
    }

    @Override
    public boolean getEscapePatternParameters() {
        return this.escapePatternParameters;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String[] getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public WhereClauseDefinition getWhereClause() {
        return this.whereClause;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public List<SortInfo> getSortInfos() {
        ArrayList<SortInfo> res = new ArrayList<SortInfo>();
        if (this.sortInfos != null) {
            for (SortInfoDescriptor sortInfo : this.sortInfos) {
                res.add(sortInfo.getSortInfo());
            }
        }
        return res;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public List<Long> getPageSizeOptions() {
        ArrayList<Long> res = new ArrayList<Long>();
        if (this.pageSizeOptions == null || this.pageSizeOptions.isEmpty()) {
            res.addAll(Arrays.asList(5L, 10L, 20L, 30L, 40L, 50L));
        } else {
            res.addAll(this.pageSizeOptions);
        }
        long defaultPageSize = this.getPageSize();
        if (!res.contains(defaultPageSize)) {
            res.add(defaultPageSize);
        }
        Collections.sort(res);
        return res;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getPageSizeBinding() {
        return this.pageSizeBinding;
    }

    @Override
    public String getSortInfosBinding() {
        return this.sortInfosBinding;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getMaxPageSize() {
        return this.maxPageSize;
    }

    @Override
    public CoreQueryPageProviderDescriptor clone() {
        String[] params;
        CoreQueryPageProviderDescriptor clone = new CoreQueryPageProviderDescriptor();
        clone.name = this.getName();
        clone.enabled = this.isEnabled();
        Map<String, String> props = this.getProperties();
        if (props != null) {
            clone.properties = new HashMap<String, String>();
            clone.properties.putAll(props);
        }
        if ((params = this.getQueryParameters()) != null) {
            clone.queryParameters = (String[])params.clone();
        }
        clone.pageSize = this.getPageSize();
        clone.pageSizeBinding = this.getPageSizeBinding();
        clone.maxPageSize = this.getMaxPageSize();
        clone.pageSizeOptions = this.getPageSizeOptions();
        clone.sortable = this.isSortable();
        if (this.sortInfos != null) {
            clone.sortInfos = new ArrayList<SortInfoDescriptor>();
            for (SortInfoDescriptor item : this.sortInfos) {
                clone.sortInfos.add(item.clone());
            }
        }
        clone.sortInfosBinding = this.getSortInfosBinding();
        clone.pattern = this.getPattern();
        clone.quotePatternParameters = this.getQuotePatternParameters();
        clone.escapePatternParameters = this.getEscapePatternParameters();
        if (this.whereClause != null) {
            clone.whereClause = this.whereClause.clone();
        }
        return clone;
    }
}

