/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.encoding;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;

public class NuxeoEncodingFilter
implements Filter {
    private static final Log log = LogFactory.getLog(NuxeoEncodingFilter.class);
    private static final String SUPPORTED_IE_LEGACY_MODE_PROPERTY = "nuxeo.ie.mode";
    private static final String SUPPORTED_IE_LEGACY_MODE_DEFAULT = "IE=8,chrome=1; IE=9,chrome=1; IE=10,chrome=1";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request != null) {
            if (request.getCharacterEncoding() == null) {
                try {
                    request.setCharacterEncoding("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            if (response instanceof HttpServletResponse && !((HttpServletResponse)response).containsHeader("X-UA-Compatible")) {
                ((HttpServletResponse)response).addHeader("X-UA-Compatible", Framework.getProperty((String)SUPPORTED_IE_LEGACY_MODE_PROPERTY, (String)SUPPORTED_IE_LEGACY_MODE_DEFAULT));
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

