/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;

@Operation(id="Context.RunFileOperation", category="Execution Flow", label="Run File Chain", description="Run an operation chain which is returning a file in the current context. The input for the chain to run is a file or a list of files. Return the output of the chain as a file or a list of files. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.")
public class RunFileChain {
    public static final String ID = "Context.RunFileOperation";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;
    @Param(name="parameters", description="Accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", required=false)
    protected Properties chainParameters;

    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        OperationContext subctx = this.ctx.getSubContext(this.isolate, blob);
        return (Blob)this.service.run(subctx, this.chainId, this.chainParameters);
    }

    @OperationMethod
    public BlobList run(BlobList blobs) throws Exception {
        BlobList result = new BlobList(blobs.size());
        for (Blob blob : blobs) {
            result.add(this.run(blob));
        }
        return result;
    }
}

