/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.scripting;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateWrapper {
    protected final long timestamp;
    protected final Calendar date;

    public DateWrapper() {
        this.date = Calendar.getInstance();
        this.timestamp = this.date.getTimeInMillis();
    }

    public DateWrapper(Calendar date) {
        this.date = date;
        this.timestamp = date.getTimeInMillis();
    }

    public DateWrapper(Date date) {
        this(date.getTime());
    }

    public DateWrapper(long date) {
        this.timestamp = date;
        this.date = Calendar.getInstance();
        this.date.setTimeInMillis(this.timestamp);
    }

    public DateWrapper months(int months) {
        return this.dateWrapper(2, months);
    }

    public DateWrapper days(int days) {
        return this.dateWrapper(5, days);
    }

    public DateWrapper years(int years) {
        return this.dateWrapper(1, years);
    }

    protected DateWrapper dateWrapper(int unit, int value) {
        Calendar calendar = (Calendar)this.date.clone();
        calendar.add(unit, value);
        return new DateWrapper(calendar);
    }

    public DateWrapper seconds(int seconds) {
        return this.dateWrapper(13, seconds);
    }

    public DateWrapper weeks(int weeks) {
        return this.dateWrapper(4, weeks);
    }

    public Calendar getCalendar() {
        return this.date;
    }

    public Date getDate() {
        return new Date(this.timestamp);
    }

    public long getTime() {
        return this.timestamp;
    }

    public int getYear() {
        return this.getCalendar().get(1);
    }

    public int getMonth() {
        return this.getCalendar().get(2);
    }

    public int getDay() {
        return this.getCalendar().get(5);
    }

    public int getMinute() {
        return this.getCalendar().get(12);
    }

    public int getHour() {
        return this.getCalendar().get(10);
    }

    public int getSecond() {
        return this.getCalendar().get(13);
    }

    public int getWeek() {
        return this.getCalendar().get(3);
    }

    public String format(String format) {
        return new SimpleDateFormat(format).format(this.date.getTime());
    }

    public String toString() {
        return this.toQueryString();
    }

    public String toQueryString() {
        return new SimpleDateFormat("'TIMESTAMP' ''yyyy-MM-dd HH:mm:ss.SSS''").format(this.getDate());
    }

    public static void main(String[] args) {
        DateWrapper d = new DateWrapper();
        System.out.println(d);
        d.months(2);
        System.out.println(d);
        d.months(-2);
        System.out.println(d);
        d.months(-2);
        System.out.println(d);
        d.months(-1);
        System.out.println(d);
        d.years(-2);
        System.out.println(d);
        d.years(4);
        System.out.println(d);
        d.weeks(2);
        System.out.println(d);
        d.weeks(-1);
        System.out.println(d);
    }
}

