/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.notification.email;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.notification.email.EmailNotificationSenderActions;
import org.nuxeo.ecm.webapp.security.PrincipalListManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="emailNotifSenderAction")
@Scope(value=ScopeType.EVENT)
public class EmailNotificationSenderActionsBean
extends InputController
implements EmailNotificationSenderActions,
Serializable {
    private static final Log log = LogFactory.getLog(EmailNotificationSenderActionsBean.class);
    private static final long serialVersionUID = 2125646683248052737L;
    @In(create=true)
    transient UserManager userManager;
    @In(create=true, required=false)
    transient CoreSession documentManager;
    @In(required=false)
    @Out(required=false)
    private String mailSubject;
    @In(required=false)
    @Out(required=false)
    private String mailContent;
    @In(required=false)
    @Out(required=false)
    private String currentDocumentFullUrl;
    @In(create=true)
    @Out
    private PrincipalListManager principalListManager;
    @Out(required=false)
    private String fromEmail;
    @Out(required=false)
    private List<NuxeoPrincipal> toEmail;

    @Override
    public String send() {
        if (this.mailSubject == null || this.mailSubject.trim().length() == 0) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.email.subject.empty"), new Object[0]);
            return null;
        }
        if (this.principalListManager.getSelectedUserListEmpty()) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.email.nousers.selected"), new Object[0]);
            return null;
        }
        for (String user : this.principalListManager.getSelectedUsers()) {
            try {
                this.sendNotificationEvent(user, this.mailSubject, this.mailContent);
            }
            catch (ClientException e) {
                this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.email.send.failed"), new Object[0]);
                return null;
            }
        }
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.email.send.ok"), new Object[0]);
        DocumentModel cDoc = this.navigationContext.getCurrentDocument();
        if (cDoc == null) {
            return null;
        }
        TypeInfo typeInfo = (TypeInfo)cDoc.getAdapter(TypeInfo.class);
        if (typeInfo != null) {
            return typeInfo.getDefaultView();
        }
        return null;
    }

    private void sendNotificationEvent(String user, String theMailSubject, String theMailContent) throws ClientException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String prefix = this.principalListManager.getPrincipalType(user) == "USER_TYPE" ? "user:" : "group:";
        String recipient = prefix + user;
        options.put("recipients", new String[]{recipient});
        options.put("mailSubject", theMailSubject);
        options.put("mailContent", theMailContent);
        options.put("category", "clientCodeNotificationCategory");
        NuxeoPrincipal currentUser = (NuxeoPrincipal)FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        DocumentEventContext ctx = new DocumentEventContext(this.documentManager, (Principal)currentUser, this.navigationContext.getCurrentDocument());
        ctx.setProperties(options);
        Event event = ctx.newEvent("emailDocumentSend");
        EventProducer evtProducer = null;
        try {
            evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            log.error((Object)"Can not get EventProducer : email won't be sent", (Throwable)e);
            return;
        }
        evtProducer.fireEvent(event);
    }

    @Override
    public String getMailContent() {
        return this.mailContent;
    }

    @Override
    public void setMailContent(String mailContent) {
        this.mailContent = mailContent;
    }

    @Override
    public String getMailSubject() {
        return this.mailSubject;
    }

    @Override
    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public PrincipalListManager getPrincipalListManager() {
        return this.principalListManager;
    }

    public void setPrincipalListManager(PrincipalListManager principalListManager) {
        this.principalListManager = principalListManager;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public List<NuxeoPrincipal> getToEmail() {
        return this.toEmail;
    }

    public void setToEmail(List<NuxeoPrincipal> toEmail) {
        this.toEmail = toEmail;
    }

    public String getCurrentDocumentFullUrl() {
        return this.currentDocumentFullUrl;
    }

    public void setCurrentDocumentFullUrl(String currentDocumentFullUrl) {
        this.currentDocumentFullUrl = currentDocumentFullUrl;
    }
}

