/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractWork
implements Work {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractWork.class);
    protected static final Random RANDOM = new Random();
    protected String id;
    protected volatile transient boolean suspending;
    protected volatile transient boolean suspended;
    protected transient Work.State state;
    protected transient Work.Progress progress;
    protected String repositoryName;
    protected String docId;
    protected List<String> docIds;
    protected boolean isTree;
    protected String status;
    protected long schedulingTime;
    protected long startTime;
    protected long completionTime;
    protected transient CoreSession session;
    protected transient WorkSchedulePath schedulePath = WorkSchedulePath.EMPTY;

    public AbstractWork() {
        this(System.nanoTime() + "." + Math.abs(RANDOM.nextInt()));
    }

    public AbstractWork(String id) {
        this.id = id;
        this.progress = Work.Progress.PROGRESS_INDETERMINATE;
        this.schedulingTime = System.currentTimeMillis();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public WorkSchedulePath getSchedulePath() {
        return this.schedulePath;
    }

    @Override
    public void setSchedulePath(WorkSchedulePath path) {
        this.schedulePath = path;
    }

    public void setDocument(String repositoryName, String docId, boolean isTree) {
        this.repositoryName = repositoryName;
        this.docId = docId;
        this.docIds = null;
        this.isTree = isTree;
    }

    public void setDocument(String repositoryName, String docId) {
        this.setDocument(repositoryName, docId, false);
    }

    public void setDocuments(String repositoryName, List<String> docIds) {
        this.repositoryName = repositoryName;
        if (docIds.size() == 1) {
            this.docId = docIds.get(0);
            this.docIds = null;
        } else {
            this.docId = null;
            this.docIds = new ArrayList<String>(docIds);
        }
    }

    @Override
    public void setWorkInstanceSuspending() {
        this.suspending = true;
    }

    @Override
    public boolean isSuspending() {
        return this.suspending;
    }

    @Override
    public void suspended() {
        this.suspended = true;
    }

    @Override
    public boolean isWorkInstanceSuspended() {
        return this.suspended;
    }

    @Override
    public void setWorkInstanceState(Work.State state) {
        this.state = state;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " state=" + (Object)((Object)state)));
        }
    }

    @Override
    public Work.State getWorkInstanceState() {
        return this.state;
    }

    @Override
    @Deprecated
    public Work.State getState() {
        return this.state;
    }

    @Override
    public void setProgress(Work.Progress progress) {
        this.progress = progress;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.valueOf(this));
        }
    }

    @Override
    public Work.Progress getProgress() {
        return this.progress;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public CoreSession initSession() throws Exception {
        return this.initSession(this.repositoryName);
    }

    public CoreSession initSession(String repositoryName) throws Exception {
        this.session = CoreInstance.openCoreSessionSystem((String)repositoryName);
        return this.session;
    }

    public void closeSession() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Override
    public void work() throws Exception {
        ConcurrentUpdateException exception = null;
        int retryCount = this.getRetryCount();
        for (int i = 0; i <= retryCount; ++i) {
            if (i > 0) {
                log.debug((Object)("Retrying work due to concurrent update (" + i + "): " + this));
                log.trace((Object)"Concurrent update", (Throwable)exception);
                this.rollbackAndRetryTransaction();
            }
            try {
                this.retryableWork();
                return;
            }
            catch (ConcurrentUpdateException e) {
                exception = e;
                continue;
            }
        }
        if (exception == null) {
            throw new RuntimeException("Invalid retry count: " + retryCount);
        }
        throw exception;
    }

    public int getRetryCount() {
        return 0;
    }

    public void retryableWork() throws Exception {
        throw new UnsupportedOperationException("Missing implementation");
    }

    @Override
    public void cleanUp(boolean ok, Exception e) {
        this.setCompletionTime();
        if (!ok) {
            if (e instanceof InterruptedException) {
                log.debug((Object)("Suspended work: " + this));
            } else {
                log.error((Object)("Exception during work: " + this), (Throwable)e);
                if (WorkSchedulePath.captureStack) {
                    WorkSchedulePath.log.error((Object)"Work schedule path", (Throwable)this.schedulePath.getStack());
                }
            }
        }
        this.closeSession();
    }

    @Override
    public String getUserId() {
        return null;
    }

    @Override
    public long getSchedulingTime() {
        return this.schedulingTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    protected void setCompletionTime() {
        this.completionTime = System.currentTimeMillis();
    }

    @Override
    public String getCategory() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('(');
        if (this.docId != null) {
            buf.append(this.docId);
            buf.append(", ");
        } else if (this.docIds != null && this.docIds.size() > 0) {
            buf.append(this.docIds.get(0));
            buf.append("..., ");
        }
        buf.append(this.getSchedulePath().getParentPath());
        buf.append(", ");
        buf.append(this.getProgress());
        buf.append(", ");
        buf.append(this.getStatus());
        buf.append(')');
        return buf.toString();
    }

    @Override
    public DocumentLocation getDocument() {
        if (this.docId != null) {
            return this.newDocumentLocation(this.docId);
        }
        return null;
    }

    @Override
    public List<DocumentLocation> getDocuments() {
        if (this.docIds != null) {
            ArrayList<DocumentLocation> res = new ArrayList<DocumentLocation>(this.docIds.size());
            for (String docId : this.docIds) {
                res.add(this.newDocumentLocation(docId));
            }
            return res;
        }
        if (this.docId != null) {
            return Collections.singletonList(this.newDocumentLocation(this.docId));
        }
        return Collections.emptyList();
    }

    protected DocumentLocation newDocumentLocation(String docId) {
        return new DocumentLocationImpl(this.repositoryName, (DocumentRef)new IdRef(docId));
    }

    @Override
    public boolean isDocumentTree() {
        return this.isTree;
    }

    public void rollbackAndRetryTransaction() {
        this.closeSession();
        TransactionHelper.setTransactionRollbackOnly();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
    }

    public void commitOrRollbackTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    public boolean startTransaction() {
        return TransactionHelper.startTransaction();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Work)) {
            return false;
        }
        return ((Work)other).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

