/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;

public class MemoryBlockingQueue
extends NuxeoBlockingQueue {
    private BlockingQueue<Runnable> queue;
    private final Set<String> workIds;

    public MemoryBlockingQueue(int capacity) {
        this.queue = new ReentrantLinkedBlockingQueue<Runnable>(capacity);
        this.workIds = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsWorkId(String workId) {
        Set<String> set = this.workIds;
        synchronized (set) {
            return this.workIds.contains(workId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable addWorkId(Runnable r) {
        if (r instanceof WorkHolder) {
            WorkHolder wh = (WorkHolder)r;
            String id = WorkHolder.getWork(wh).getId();
            Set<String> set = this.workIds;
            synchronized (set) {
                this.workIds.add(id);
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable removeWorkId(Runnable r) {
        if (r instanceof WorkHolder) {
            WorkHolder wh = (WorkHolder)r;
            String id = WorkHolder.getWork(wh).getId();
            Set<String> set = this.workIds;
            synchronized (set) {
                this.workIds.remove(id);
            }
        }
        return r;
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public void putElement(Runnable r) throws InterruptedException {
        this.queue.put(r);
        this.addWorkId(r);
    }

    @Override
    public Runnable pollElement() {
        Runnable r = (Runnable)this.queue.poll();
        this.removeWorkId(r);
        return r;
    }

    @Override
    public Iterator<Runnable> iterator() {
        return new Itr(this.queue.iterator());
    }

    private class Itr
    implements Iterator<Runnable> {
        private Iterator<Runnable> it;
        private Runnable last;

        public Itr(Iterator<Runnable> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Runnable next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            this.it.remove();
            MemoryBlockingQueue.this.removeWorkId(this.last);
        }
    }

    private static class ReentrantLinkedBlockingQueue<T>
    extends LinkedBlockingQueue<T> {
        private static final long serialVersionUID = 1L;
        private final ReentrantLock limitedPutLock = new ReentrantLock();
        private final int limitedCapacity;

        public ReentrantLinkedBlockingQueue(int capacity) {
            super(capacity < 0 ? Integer.MAX_VALUE : 2 * capacity);
            this.limitedCapacity = capacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void limitedPut(T e) throws InterruptedException {
            this.limitedPutLock.lockInterruptibly();
            try {
                while (this.remainingCapacity() < this.limitedCapacity) {
                    Thread.sleep(100L);
                }
                this.put(e);
            }
            finally {
                this.limitedPutLock.unlock();
            }
        }

        @Override
        public boolean offer(T e) {
            if (this.limitedCapacity < 0) {
                return super.offer(e);
            }
            try {
                if (Thread.currentThread().getName().startsWith("Nuxeo-Work-")) {
                    this.put(e);
                } else {
                    this.limitedPut(e);
                }
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("interrupted", ie);
            }
        }
    }
}

