/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.MemoryWorkQueuing;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkQueueDescriptorRegistry;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.ecm.core.work.api.WorkQueuingImplDescriptor;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WorkManagerImpl
extends DefaultComponent
implements WorkManager {
    private static final Log log = LogFactory.getLog(WorkManagerImpl.class);
    public static final String DEFAULT_WORK_QUEUING = MemoryWorkQueuing.class.getName();
    protected static final String QUEUES_EP = "queues";
    protected static final String IMPL_EP = "implementation";
    public static final String DEFAULT_QUEUE_ID = "default";
    public static final String DEFAULT_CATEGORY = "default";
    protected static final int DEFAULT_MAX_POOL_SIZE = 4;
    protected static final String THREAD_PREFIX = "Nuxeo-Work-";
    protected WorkQueueDescriptorRegistry workQueueDescriptors;
    protected Map<String, WorkThreadPoolExecutor> executors;
    protected Map<String, WorkAndScheduling> scheduledAfterCommit = new LinkedHashMap<String, WorkAndScheduling>();
    protected WorkQueuing queuing;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.workQueueDescriptors = new WorkQueueDescriptorRegistry();
        if (this.queuing == null) {
            this.queuing = this.newWorkQueuingDefault();
        }
        this.init();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.closeQueuing();
        this.queuing = null;
        this.workQueueDescriptors = null;
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (QUEUES_EP.equals(extensionPoint)) {
            this.registerWorkQueueDescriptor((WorkQueueDescriptor)contribution);
        } else if (IMPL_EP.equals(extensionPoint)) {
            this.registerWorkQueuingDescriptor((WorkQueuingImplDescriptor)contribution);
        } else {
            throw new RuntimeException("Unknown extension point: " + extensionPoint);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (QUEUES_EP.equals(extensionPoint)) {
            this.unregisterWorkQueueDescriptor((WorkQueueDescriptor)contribution);
        } else if (IMPL_EP.equals(extensionPoint)) {
            this.unregisterWorkQueuingDescriptor((WorkQueuingImplDescriptor)contribution);
        } else {
            throw new RuntimeException("Unknown extension point: " + extensionPoint);
        }
    }

    public void registerWorkQueueDescriptor(WorkQueueDescriptor workQueueDescriptor) {
        Boolean processing = workQueueDescriptor.processing;
        Boolean queuing = workQueueDescriptor.queuing;
        if ("*".equals(workQueueDescriptor.id)) {
            if (processing == null && queuing == null) {
                log.error((Object)"Ignoring work queue descriptor * with no processing/queueing");
                return;
            }
            ArrayList<String> queueIds = new ArrayList<String>(this.workQueueDescriptors.getQueueIds());
            String what = processing == null ? "" : " processing=" + processing;
            what = what + (queuing == null ? "" : " queuing=" + queuing);
            log.info((Object)("Setting on all work queues " + queueIds + what));
            for (String queueId : queueIds) {
                WorkQueueDescriptor wqd = this.workQueueDescriptors.get(queueId);
                wqd.processing = processing;
                wqd.queuing = queuing;
                this.addWorkQueueDescriptor(wqd);
            }
            return;
        }
        String what = Boolean.FALSE.equals(processing) ? " (no processing)" : "";
        what = what + (Boolean.FALSE.equals(queuing) ? " (no queuing)" : "");
        log.info((Object)("Registered work queue " + workQueueDescriptor.id + what));
        this.addWorkQueueDescriptor(workQueueDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterWorkQueueDescriptor(WorkQueueDescriptor workQueueDescriptor) {
        if ("*".equals(workQueueDescriptor.id)) {
            return;
        }
        log.info((Object)("Unregistered work queue " + workQueueDescriptor.id));
        WorkQueueDescriptorRegistry workQueueDescriptorRegistry = this.workQueueDescriptors;
        synchronized (workQueueDescriptorRegistry) {
            this.workQueueDescriptors.removeContribution(workQueueDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWorkQueueDescriptor(WorkQueueDescriptor workQueueDescriptor) {
        WorkQueueDescriptorRegistry workQueueDescriptorRegistry = this.workQueueDescriptors;
        synchronized (workQueueDescriptorRegistry) {
            this.workQueueDescriptors.addContribution(workQueueDescriptor);
            String id = workQueueDescriptor.id;
            NuxeoBlockingQueue queue = (NuxeoBlockingQueue)this.getExecutor(id).getQueue();
            WorkQueueDescriptor wqd = this.workQueueDescriptors.get(id);
            queue.setActive(wqd.isProcessingEnabled());
        }
    }

    protected void registerWorkQueuingDescriptor(WorkQueuingImplDescriptor descr) {
        WorkQueuing q = this.newWorkQueuing(descr.getWorkQueuingClass());
        this.closeQueuing();
        this.queuing = q;
    }

    protected void unregisterWorkQueuingDescriptor(WorkQueuingImplDescriptor descr) {
        this.closeQueuing();
        this.queuing = this.newWorkQueuingDefault();
    }

    protected WorkQueuing newWorkQueuingDefault() {
        Class<?> klass;
        try {
            klass = Class.forName(DEFAULT_WORK_QUEUING);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (!WorkQueuing.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Class is not a " + WorkQueuing.class.getSimpleName() + " implementation: " + DEFAULT_WORK_QUEUING);
        }
        Class<?> workQueuingClass = klass;
        return this.newWorkQueuing(workQueuingClass);
    }

    protected WorkQueuing newWorkQueuing(Class<? extends WorkQueuing> klass) {
        WorkQueuing q;
        try {
            Constructor<? extends WorkQueuing> ctor = klass.getConstructor(WorkQueueDescriptorRegistry.class);
            q = ctor.newInstance(new Object[]{this.workQueueDescriptors});
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
        return q;
    }

    protected void closeQueuing() {
        try {
            this.shutdown(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected boolean isQueuingEnabled(String queueId) {
        return this.getWorkQueueDescriptor(queueId).isQueuingEnabled();
    }

    protected boolean isProcessingEnabled(String queueId) {
        return this.getWorkQueueDescriptor(queueId).isProcessingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWorkQueueIds() {
        WorkQueueDescriptorRegistry workQueueDescriptorRegistry = this.workQueueDescriptors;
        synchronized (workQueueDescriptorRegistry) {
            return this.workQueueDescriptors.getQueueIds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkQueueDescriptor getWorkQueueDescriptor(String queueId) {
        WorkQueueDescriptorRegistry workQueueDescriptorRegistry = this.workQueueDescriptors;
        synchronized (workQueueDescriptorRegistry) {
            return this.workQueueDescriptors.get(queueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCategoryQueueId(String category) {
        String queueId;
        if (category == null) {
            category = "default";
        }
        WorkQueueDescriptorRegistry workQueueDescriptorRegistry = this.workQueueDescriptors;
        synchronized (workQueueDescriptorRegistry) {
            queueId = this.workQueueDescriptors.getQueueId(category);
        }
        if (queueId == null) {
            queueId = "default";
        }
        return queueId;
    }

    @Override
    public void init() {
        this.executors = new HashMap<String, WorkThreadPoolExecutor>();
        this.queuing.init();
        this.startExecutors();
    }

    private void startExecutors() {
        for (String queueId : this.getWorkQueueIds()) {
            this.getExecutor(queueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized WorkThreadPoolExecutor getExecutor(String queueId) {
        WorkQueueDescriptor workQueueDescriptor;
        WorkQueueDescriptorRegistry workQueueDescriptorRegistry = this.workQueueDescriptors;
        synchronized (workQueueDescriptorRegistry) {
            workQueueDescriptor = this.workQueueDescriptors.get(queueId);
        }
        if (workQueueDescriptor == null) {
            throw new IllegalArgumentException("No such work queue: " + queueId);
        }
        WorkThreadPoolExecutor executor = this.executors.get(queueId);
        if (executor == null) {
            NamedThreadFactory threadFactory = new NamedThreadFactory(THREAD_PREFIX + queueId + "-");
            int maxPoolSize = workQueueDescriptor.maxThreads;
            if (maxPoolSize <= 0) {
                workQueueDescriptor.maxThreads = maxPoolSize = 4;
            }
            executor = new WorkThreadPoolExecutor(queueId, maxPoolSize, maxPoolSize, 0L, TimeUnit.SECONDS, this.queuing, threadFactory);
            executor.prestartAllCoreThreads();
            this.executors.put(queueId, executor);
        }
        return executor;
    }

    @Override
    public boolean shutdownQueue(String queueId, long timeout, TimeUnit unit) throws InterruptedException {
        WorkThreadPoolExecutor executor = this.getExecutor(queueId);
        boolean terminated = this.shutdownExecutors(Collections.singleton(executor), timeout, unit);
        this.removeExecutor(queueId);
        return terminated;
    }

    protected boolean shutdownExecutors(Collection<WorkThreadPoolExecutor> list, long timeout, TimeUnit unit) throws InterruptedException {
        for (WorkThreadPoolExecutor executor : list) {
            executor.shutdownAndSuspend();
        }
        long t0 = System.currentTimeMillis();
        long delay = unit.toMillis(timeout);
        boolean terminated = true;
        for (WorkThreadPoolExecutor executor : list) {
            long remaining;
            if (executor.awaitTerminationOrSave(remaining = this.remainingMillis(t0, delay), TimeUnit.MILLISECONDS)) continue;
            terminated = false;
            executor.shutdownNow();
        }
        return terminated;
    }

    protected long remainingMillis(long t0, long delay) {
        long d = System.currentTimeMillis() - t0;
        if (d > delay) {
            return 0L;
        }
        return delay - d;
    }

    protected synchronized void removeExecutor(String queueId) {
        this.executors.remove(queueId);
    }

    @Override
    public synchronized boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executors == null) {
            return true;
        }
        ArrayList<WorkThreadPoolExecutor> executorList = new ArrayList<WorkThreadPoolExecutor>(this.executors.values());
        this.executors.clear();
        return this.shutdownExecutors(executorList, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Work findScheduledAfterCommit(String workId) {
        Map<String, WorkAndScheduling> map = this.scheduledAfterCommit;
        synchronized (map) {
            WorkAndScheduling ws = this.scheduledAfterCommit.get(workId);
            return ws == null ? null : ws.work;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Work removeScheduledAfterCommit(String workId) {
        Map<String, WorkAndScheduling> map = this.scheduledAfterCommit;
        synchronized (map) {
            WorkAndScheduling ws = this.scheduledAfterCommit.remove(workId);
            return ws == null ? null : ws.work;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Work> getScheduledAfterCommit() {
        Map<String, WorkAndScheduling> map = this.scheduledAfterCommit;
        synchronized (map) {
            return WorkAndScheduling.getWorkList(this.scheduledAfterCommit.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAfterCommit(Work work, WorkManager.Scheduling scheduling) {
        Map<String, WorkAndScheduling> map = this.scheduledAfterCommit;
        synchronized (map) {
            WorkAndScheduling ws = new WorkAndScheduling(work, scheduling);
            this.scheduledAfterCommit.put(work.getId(), ws);
        }
    }

    @Override
    public void schedule(Work work) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, false);
    }

    @Override
    public void schedule(Work work, boolean afterCommit) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, afterCommit);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling) {
        this.schedule(work, scheduling, false);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling, boolean afterCommit) {
        String workId = work.getId();
        String queueId = this.getCategoryQueueId(work.getCategory());
        if (!this.isQueuingEnabled(queueId)) {
            work.setWorkInstanceState(Work.State.CANCELED);
            return;
        }
        work.setWorkInstanceState(Work.State.SCHEDULED);
        if (afterCommit && this.scheduleAfterCommit(work, scheduling)) {
            return;
        }
        WorkSchedulePath.newInstance(work);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scheduling work: " + work + " using queue: " + queueId), (Throwable)work.getSchedulePath().getStack());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduling work: " + work + " using queue: " + queueId));
        }
        switch (scheduling) {
            case ENQUEUE: {
                break;
            }
            case CANCEL_SCHEDULED: {
                Work w = this.removeScheduledAfterCommit(workId);
                if (w == null) {
                    w = this.getExecutor(queueId).removeScheduled(workId);
                }
                if (w == null) break;
                w.setWorkInstanceState(Work.State.CANCELED);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Canceling existing scheduled work before scheduling");
                break;
            }
            case IF_NOT_SCHEDULED: 
            case IF_NOT_RUNNING: 
            case IF_NOT_RUNNING_OR_SCHEDULED: {
                boolean disabled = Boolean.TRUE;
                if (disabled || !this.hasWorkInState(workId, scheduling.state)) break;
                work.setWorkInstanceState(Work.State.CANCELED);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Canceling schedule because found: " + (Object)((Object)scheduling)));
                }
                return;
            }
        }
        this.getExecutor(queueId).execute(work);
    }

    protected boolean scheduleAfterCommit(Work work, WorkManager.Scheduling scheduling) {
        TransactionManager transactionManager;
        try {
            transactionManager = TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            transactionManager = null;
        }
        if (transactionManager == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not scheduling work after commit because of missing transaction manager: " + work));
            }
            return false;
        }
        try {
            Transaction transaction = transactionManager.getTransaction();
            if (transaction == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Not scheduling work after commit because of missing transaction: " + work));
                }
                return false;
            }
            int status = transaction.getStatus();
            if (status == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scheduling work after commit: " + work));
                }
                this.executeAfterCommit(work, scheduling);
                transaction.registerSynchronization((Synchronization)new WorkSchedulingSynchronization(this.scheduledAfterCommit, this));
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not scheduling work after commit because transaction is in status " + status + ": " + work));
            }
            return false;
        }
        catch (RollbackException | SystemException e) {
            log.error((Object)"Cannot schedule after commit", e);
            return false;
        }
    }

    @Override
    @Deprecated
    public Work find(Work work, Work.State state, boolean useEquals, int[] pos) {
        Work w;
        if (pos != null) {
            pos[0] = 0;
        }
        String workId = work.getId();
        if ((state == null || state == Work.State.SCHEDULED) && (w = this.findScheduledAfterCommit(workId)) != null) {
            return w;
        }
        return this.queuing.find(workId, state);
    }

    protected boolean hasWorkInState(String workId, Work.State state) {
        if ((state == null || state == Work.State.SCHEDULED) && this.findScheduledAfterCommit(workId) != null) {
            return true;
        }
        return this.queuing.isWorkInState(workId, state);
    }

    @Override
    public Work.State getWorkState(String workId) {
        if (this.findScheduledAfterCommit(workId) != null) {
            return Work.State.SCHEDULED;
        }
        return this.queuing.getWorkState(workId);
    }

    @Override
    public List<Work> listWork(String queueId, Work.State state) {
        return this.queuing.listWork(queueId, state);
    }

    @Override
    public List<String> listWorkIds(String queueId, Work.State state) {
        return this.queuing.listWorkIds(queueId, state);
    }

    @Override
    public int getQueueSize(String queueId, Work.State state) {
        if (state == null) {
            return this.getScheduledAfterCommitSize() + this.getScheduledOrRunningSize(queueId);
        }
        if (state == Work.State.SCHEDULED) {
            return this.getScheduledAfterCommitSize() + this.getScheduledSize(queueId);
        }
        if (state == Work.State.RUNNING) {
            return this.getRunningSize(queueId);
        }
        if (state == Work.State.COMPLETED) {
            return this.getCompletedSize(queueId);
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    @Deprecated
    public int getNonCompletedWorkSize(String queueId) {
        return this.getScheduledOrRunningSize(queueId);
    }

    protected int getScheduledAfterCommitSize() {
        return this.scheduledAfterCommit.size();
    }

    protected int getScheduledSize(String queueId) {
        return this.queuing.getQueueSize(queueId, Work.State.SCHEDULED);
    }

    protected int getRunningSize(String queueId) {
        return this.queuing.getQueueSize(queueId, Work.State.RUNNING);
    }

    protected int getScheduledOrRunningSize(String queueId) {
        return this.getExecutor(queueId).getScheduledOrRunningSize();
    }

    protected int getCompletedSize(String queueId) {
        return this.queuing.getQueueSize(queueId, Work.State.COMPLETED);
    }

    @Override
    public boolean awaitCompletion(String queueId, long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitCompletion(Collections.singleton(queueId), timeout, unit);
    }

    @Override
    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitCompletion(this.getWorkQueueIds(), timeout, unit);
    }

    private boolean awaitCompletion(Collection<String> queueIds, long timeout, TimeUnit unit) throws InterruptedException {
        long t0 = System.currentTimeMillis();
        long delay = unit.toMillis(timeout);
        while (true) {
            boolean completed = true;
            for (String queueId : queueIds) {
                if (this.getScheduledAfterCommitSize() == 0 && this.getScheduledOrRunningSize(queueId) == 0) continue;
                completed = false;
                break;
            }
            if (completed) {
                return true;
            }
            if (System.currentTimeMillis() - t0 > delay) {
                return false;
            }
            Thread.sleep(50L);
        }
    }

    @Override
    public synchronized void clearCompletedWork(String queueId) {
        this.queuing.clearCompletedWork(queueId, 0L);
    }

    @Override
    public synchronized void clearCompletedWork(long completionTime) {
        for (String queueId : this.queuing.getCompletedQueueIds()) {
            this.queuing.clearCompletedWork(queueId, completionTime);
        }
    }

    @Override
    public synchronized void cleanup() {
        log.debug((Object)"Clearing old completed work");
        for (String queueId : this.queuing.getCompletedQueueIds()) {
            long delay;
            WorkQueueDescriptor workQueueDescriptor = this.workQueueDescriptors.get(queueId);
            if (workQueueDescriptor == null || (delay = (long)workQueueDescriptor.clearCompletedAfterSeconds * 1000L) <= 0L) continue;
            long completionTime = System.currentTimeMillis() - delay;
            this.queuing.clearCompletedWork(queueId, completionTime);
        }
    }

    public static class WorkThreadPoolExecutor
    extends ThreadPoolExecutor {
        protected final String queueId;
        protected final WorkQueuing queuing;
        protected final AtomicInteger scheduledOrRunning = new AtomicInteger();
        protected final List<Work> running;
        protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        protected final Counter scheduledCount;
        protected final Counter scheduledMax;
        protected final Counter runningCount;
        protected final Counter completedCount;
        protected final Timer workTimer;

        public WorkThreadPoolExecutor(String queueId, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, WorkQueuing queuing, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, queuing.getScheduledQueue(queueId), threadFactory);
            this.queueId = queueId;
            this.queuing = queuing;
            this.running = new LinkedList<Work>();
            this.scheduledCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "scheduled", "count"}));
            this.scheduledMax = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "scheduled", "max"}));
            this.runningCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "running"}));
            this.completedCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "completed"}));
            this.workTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "total"}));
        }

        public int getScheduledOrRunningSize() {
            return this.scheduledOrRunning.get();
        }

        @Override
        public void execute(Runnable r) {
            throw new UnsupportedOperationException("use other api");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Work work) {
            this.scheduledCount.inc();
            if (this.scheduledCount.getCount() > this.scheduledMax.getCount()) {
                this.scheduledMax.inc();
            }
            this.scheduledOrRunning.incrementAndGet();
            boolean ok = false;
            try {
                BlockingQueue<Runnable> queue = this.queuing.getScheduledQueue(this.queueId);
                boolean added = queue.offer(new WorkHolder(work));
                if (!added) {
                    throw new RuntimeException("queue should have blocked");
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    this.scheduledOrRunning.decrementAndGet();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            Work work = WorkHolder.getWork(r);
            work.setWorkInstanceState(Work.State.RUNNING);
            this.queuing.workRunning(this.queueId, work);
            List<Work> list = this.running;
            synchronized (list) {
                this.running.add(work);
            }
            this.scheduledCount.dec();
            this.runningCount.inc();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.scheduledOrRunning.decrementAndGet();
            Work work = WorkHolder.getWork(r);
            List<Work> list = this.running;
            synchronized (list) {
                this.running.remove(work);
            }
            Work.State state = t == null ? (work.isWorkInstanceSuspended() ? Work.State.SCHEDULED : Work.State.COMPLETED) : Work.State.FAILED;
            work.setWorkInstanceState(state);
            this.queuing.workCompleted(this.queueId, work);
            this.runningCount.dec();
            this.completedCount.inc();
            this.workTimer.update(work.getCompletionTime() - work.getStartTime(), TimeUnit.MILLISECONDS);
        }

        protected void removedFromQueue(Runnable r) {
            Work work = WorkHolder.getWork(r);
            work.setWorkInstanceState(Work.State.CANCELED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownAndSuspend() {
            this.setRejectedExecutionHandler(CancelingPolicy.INSTANCE);
            this.shutdown();
            int n = this.queuing.setSuspending(this.queueId);
            this.scheduledOrRunning.addAndGet(-n);
            List<Work> list = this.running;
            synchronized (list) {
                for (Work work : this.running) {
                    work.setWorkInstanceSuspending();
                }
            }
        }

        public boolean awaitTerminationOrSave(long timeout, TimeUnit unit) throws InterruptedException {
            boolean terminated = super.awaitTermination(timeout, unit);
            if (!terminated) {
                ArrayList drained = new ArrayList();
                this.getQueue().drainTo(drained);
                for (Runnable r : drained) {
                    this.removedFromQueue(r);
                }
            }
            return terminated;
        }

        public Work removeScheduled(String workId) {
            Work w = this.queuing.removeScheduled(this.queueId, workId);
            if (w != null) {
                this.scheduledOrRunning.decrementAndGet();
            }
            return w;
        }
    }

    public static class CancelingPolicy
    implements RejectedExecutionHandler {
        public static final CancelingPolicy INSTANCE = new CancelingPolicy();

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            ((WorkThreadPoolExecutor)executor).removedFromQueue(r);
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.incrementAndGet();
            Thread thread = new Thread(this.group, r, name);
            thread.setPriority(5);
            return thread;
        }
    }

    public static class WorkSchedulingSynchronization
    implements Synchronization {
        protected final Map<String, WorkAndScheduling> scheduledAfterCommit;
        protected final WorkManager workManager;

        public WorkSchedulingSynchronization(Map<String, WorkAndScheduling> scheduledAfterCommit, WorkManager workManager) {
            this.scheduledAfterCommit = scheduledAfterCommit;
            this.workManager = workManager;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            WorkAndScheduling[] copy;
            Map<String, WorkAndScheduling> map = this.scheduledAfterCommit;
            synchronized (map) {
                copy = this.scheduledAfterCommit.values().toArray(new WorkAndScheduling[0]);
                this.scheduledAfterCommit.clear();
            }
            for (WorkAndScheduling ws : copy) {
                Work work = ws.work;
                if (status == 3) {
                    this.workManager.schedule(work, ws.scheduling, false);
                    continue;
                }
                if (status == 4) {
                    work.setWorkInstanceState(Work.State.CANCELED);
                    continue;
                }
                log.error((Object)("Unexpected status after completion: " + status));
            }
        }
    }

    public static class WorkAndScheduling {
        public final Work work;
        public final WorkManager.Scheduling scheduling;

        public WorkAndScheduling(Work work, WorkManager.Scheduling scheduling) {
            this.work = work;
            this.scheduling = scheduling;
        }

        public static List<Work> getWorkList(Collection<WorkAndScheduling> lws) {
            LinkedList<Work> list = new LinkedList<Work>();
            for (WorkAndScheduling ws : lws) {
                list.add(ws.work);
            }
            return list;
        }
    }
}

