/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.api;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="queue")
public class WorkQueueDescriptor {
    public static final String ALL_QUEUES = "*";
    @XNode(value="@id")
    public String id;
    @XNode(value="@queueing")
    public Boolean queuing;
    @XNode(value="@processing")
    public Boolean processing;
    @XNode(value="name")
    public String name;
    @XNode(value="maxThreads")
    public int maxThreads;
    @XNode(value="usePriority")
    public boolean usePriority;
    @XNode(value="clearCompletedAfterSeconds")
    public int clearCompletedAfterSeconds = 3600;
    @XNodeList(value="category", type=HashSet.class, componentType=String.class)
    public Set<String> categories;
    @XNode(value="capacity")
    public int capacity = -1;

    public boolean isQueuingEnabled() {
        return !Boolean.FALSE.equals(this.queuing);
    }

    public boolean isProcessingEnabled() {
        return !Boolean.FALSE.equals(this.processing);
    }

    public WorkQueueDescriptor clone() {
        WorkQueueDescriptor o = new WorkQueueDescriptor();
        o.id = this.id;
        o.queuing = this.queuing;
        o.processing = this.processing;
        o.name = this.name;
        o.maxThreads = this.maxThreads;
        o.usePriority = this.usePriority;
        o.clearCompletedAfterSeconds = this.clearCompletedAfterSeconds;
        o.capacity = this.capacity;
        o.categories = new HashSet<String>(this.categories);
        return o;
    }

    public void merge(WorkQueueDescriptor other) {
        if (other.queuing != null) {
            this.queuing = other.queuing;
        }
        if (other.processing != null) {
            this.processing = other.processing;
        }
        this.name = other.name;
        this.maxThreads = other.maxThreads;
        this.usePriority = other.usePriority;
        this.clearCompletedAfterSeconds = other.clearCompletedAfterSeconds;
        this.capacity = other.capacity;
        this.categories.addAll(other.categories);
    }
}

