/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.redis;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.redis.RedisWorkQueuing;

public class RedisBlockingQueue
extends NuxeoBlockingQueue {
    private static final Log log = LogFactory.getLog(RedisBlockingQueue.class);
    protected final String queueId;
    protected final RedisWorkQueuing queuing;

    public RedisBlockingQueue(String queueId, RedisWorkQueuing queuing) {
        this.queueId = queueId;
        this.queuing = queuing;
    }

    @Override
    public int getQueueSize() {
        return this.queuing.getScheduledSize(this.queueId);
    }

    @Override
    public void putElement(Runnable r) {
        Work work = WorkHolder.getWork(r);
        try {
            this.queuing.addScheduledWork(this.queueId, work);
        }
        catch (IOException e) {
            log.error((Object)("Failed to add Work: " + work), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Runnable pollElement() {
        try {
            Work work = this.queuing.removeScheduledWork(this.queueId);
            if (work != null) {
                log.debug((Object)("Remove scheduled " + work));
            }
            return work == null ? null : new WorkHolder(work);
        }
        catch (IOException e) {
            log.error((Object)("Failed to remove Work from queue: " + this.queueId), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

