/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.jsf.actions;

import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="currentDocumentCollection")
@Scope(value=ScopeType.PAGE)
@BypassInterceptors
public class CurrentDocumentCollectionBean {
    protected boolean hasCurrentDocumentMoreCollectionToDisplay = false;
    private boolean isDisplayAll;

    public List<DocumentModel> getCurrentDocumentCollections() throws ClientException {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        if (!collectionManager.isCollectable(currentDocument)) {
            return null;
        }
        CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
        List result = collectionManager.getVisibleCollection(currentDocument, this.isDisplayAll ? 100 : 10, session);
        if (!this.isDisplayAll && result.size() == 10) {
            this.hasCurrentDocumentMoreCollectionToDisplay = true;
        } else {
            this.isDisplayAll = true;
            this.hasCurrentDocumentMoreCollectionToDisplay = false;
        }
        return result;
    }

    public Boolean getHasCurrentDocumentMoreCollectionToDisplay() {
        return this.hasCurrentDocumentMoreCollectionToDisplay;
    }

    public boolean isDisplayAll() {
        return this.isDisplayAll;
    }

    public void setDisplayAll(boolean isDisplayAll) {
        this.isDisplayAll = isDisplayAll;
    }
}

