/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding;

import java.io.Serializable;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

public class DownloadMethodExpression
extends MethodExpression
implements Serializable {
    private static final long serialVersionUID = 9010857019674405375L;
    private final ValueExpression blobExpression;
    private final ValueExpression fileNameExpression;

    public DownloadMethodExpression(ValueExpression blobExpression, ValueExpression fileNameExpression) {
        this.blobExpression = blobExpression;
        this.fileNameExpression = fileNameExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadMethodExpression)) {
            return false;
        }
        DownloadMethodExpression other = (DownloadMethodExpression)o;
        if (this.blobExpression != null ? !this.blobExpression.equals((Object)other.blobExpression) : other.blobExpression != null) {
            return false;
        }
        return !(this.fileNameExpression != null ? !this.fileNameExpression.equals((Object)other.fileNameExpression) : other.fileNameExpression != null);
    }

    public int hashCode() {
        int result = this.blobExpression != null ? this.blobExpression.hashCode() : 0;
        result = 31 * result + (this.fileNameExpression != null ? this.fileNameExpression.hashCode() : 0);
        return result;
    }

    public String getExpressionString() {
        return this.blobExpression == null ? null : this.blobExpression.getExpressionString();
    }

    public boolean isLiteralText() {
        return this.blobExpression == null ? null : Boolean.valueOf(this.blobExpression.isLiteralText());
    }

    public MethodInfo getMethodInfo(ELContext context) {
        return null;
    }

    public Object invoke(ELContext context, Object[] params) {
        FacesContext faces = FacesContext.getCurrentInstance();
        Blob blob = this.getBlob(context);
        String filename = this.getFilename(context);
        return ComponentUtils.download(faces, blob, filename);
    }

    protected String getFilename(ELContext context) {
        if (this.fileNameExpression == null) {
            return null;
        }
        return (String)this.fileNameExpression.getValue(context);
    }

    protected Blob getBlob(ELContext context) {
        if (this.blobExpression == null) {
            return null;
        }
        return (Blob)this.blobExpression.getValue(context);
    }
}

