/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.automation;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Collection.Suggestion", category="Services", label="Get collection suggestion", description="Get the collection list accessible by the current user. This is returning a blob containing a serialized JSON array..", addToStudio=false)
public class SuggestCollectionEntry {
    public static final String ID = "Collection.Suggestion";
    private static final String PATH = "path";
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex = 0;
    @Param(name="pageSize", required=false)
    protected Integer pageSize = 20;
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Context
    protected CollectionManager collectionManager;
    @Param(name="searchTerm", required=false)
    protected String searchTerm;

    @OperationMethod
    public Blob run() throws ClientException {
        JSONArray result = new JSONArray();
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        Object[] paramaters = new Object[]{this.searchTerm + (this.searchTerm.endsWith("%") ? "" : "%")};
        Long targetPageSize = this.pageSize.longValue();
        Long targetPage = this.currentPageIndex.longValue();
        DocumentModelList docs = (DocumentModelList)pps.getPageProvider("default_collection", null, targetPageSize, targetPage, props, paramaters).getCurrentPage();
        boolean found = false;
        for (DocumentModel doc : docs) {
            JSONObject obj = new JSONObject();
            if (this.collectionManager.canAddToCollection(doc, this.session)) {
                obj.element("id", (Object)doc.getId());
            }
            if (doc.getTitle().equals(this.searchTerm)) {
                found = true;
            }
            obj.element("displayLabel", (Object)doc.getTitle());
            obj.element(PATH, (Object)doc.getPath().toString());
            result.add((Object)obj);
        }
        if (!found && StringUtils.isNotBlank((String)this.searchTerm)) {
            JSONObject obj = new JSONObject();
            obj.element("displayLabel", (Object)this.searchTerm);
            obj.element("id", (Object)("-999999" + this.searchTerm));
            result.add(0, (Object)obj);
        }
        return new StringBlob(result.toString(), "application/json");
    }
}

