/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.localconf;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.localconfiguration.search.SearchLocalConfiguration;
import org.nuxeo.runtime.api.Framework;

@Name(value="searchConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class SearchConfigurationActions
implements Serializable {
    private static final Log log = LogFactory.getLog(SearchConfigurationActions.class);
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;

    public String getAdvancedSearchView() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        SearchLocalConfiguration configuration = null;
        try {
            LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
            configuration = (SearchLocalConfiguration)localConfigurationService.getConfiguration(SearchLocalConfiguration.class, "SearchLocalConfiguration", currentDoc);
            if (this.isLocalConfigurationExistsAndSearchViewAvailable(configuration)) {
                return configuration.getAdvancedSearchView();
            }
        }
        catch (Exception e) {
            log.debug((Object)("failed to get search configuration for " + currentDoc.getPathAsString()), (Throwable)e);
        }
        return "advanced_search";
    }

    protected boolean isLocalConfigurationExistsAndSearchViewAvailable(SearchLocalConfiguration configuration) {
        return configuration != null && configuration.getAdvancedSearchView() != null;
    }
}

