/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.jsf;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.connect.client.jsf.AppCenterViewsManager;
import org.nuxeo.connect.client.status.ConnectStatusHolder;
import org.nuxeo.connect.client.status.ConnectUpdateStatusInfo;
import org.nuxeo.connect.client.status.SubscriptionStatusWrapper;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.data.SubscriptionStatusType;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.runtime.api.Framework;

@Name(value="connectStatus")
@Scope(value=ScopeType.CONVERSATION)
public class ConnectStatusActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CLIENT_BANNER_TYPE = "clientSideBanner";
    public static final String SERVER_BANNER_TYPE = "serverSideBanner";
    private static final Log log = LogFactory.getLog(ConnectStatusActionBean.class);
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true, required=true, value="appsViews")
    protected AppCenterViewsManager appsViews;
    @In(create=true)
    protected Map<String, String> messages;
    protected String login;
    protected String password;
    protected String registredProject;
    protected String instanceType;
    protected String instanceDescription;
    protected boolean loginValidated = false;
    protected String CLID;
    protected ConnectUpdateStatusInfo connectionStatusCache;
    protected Blob packageToUpload;
    protected String packageFileName;

    public String getRegistredCLID() throws Exception {
        if (this.isRegistred()) {
            return LogicalInstanceIdentifier.instance().getCLID();
        }
        return null;
    }

    public String getCLID() {
        return this.CLID;
    }

    public void setCLID(String cLID) {
        this.CLID = cLID;
    }

    public String unregister() {
        LogicalInstanceIdentifier.cleanUp();
        this.resetRegister();
        return null;
    }

    public List<SelectItem> getInstanceTypes() {
        ArrayList<SelectItem> types = new ArrayList<SelectItem>();
        for (NuxeoClientInstanceType itype : NuxeoClientInstanceType.values()) {
            SelectItem item = new SelectItem((Object)itype.getValue(), "label.instancetype." + itype.getValue());
            types.add(item);
        }
        return types;
    }

    @Factory(scope=ScopeType.EVENT, value="connectLoginValidated")
    public boolean isLoginValidated() {
        return this.loginValidated;
    }

    protected ConnectRegistrationService getService() {
        return (ConnectRegistrationService)Framework.getLocalService(ConnectRegistrationService.class);
    }

    public String getRegistredProject() {
        return this.registredProject;
    }

    public void setRegistredProject(String registredProject) {
        this.registredProject = registredProject;
    }

    public String getConnectLogin() {
        return this.login;
    }

    public void setConnectLogin(String login) {
        this.login = login;
    }

    public String getConnectPassword() {
        return this.password;
    }

    public void setConnectPassword(String password) {
        this.password = password;
    }

    @Factory(scope=ScopeType.APPLICATION, value="registredConnectInstance")
    public boolean isRegistred() {
        return this.getService().isInstanceRegistred();
    }

    protected void flushContextCache() {
        Contexts.getEventContext().remove("connectLoginValidated");
        Contexts.getEventContext().remove("projectsForRegistration");
        Contexts.getApplicationContext().remove("registredConnectInstance");
        Contexts.getApplicationContext().remove("connectUpdateStatusInfo");
        this.appsViews.flushCache();
    }

    public void validateLogin() {
        if (this.login == null || this.password == null) {
            this.facesMessages.addToControl("login", StatusMessage.Severity.WARN, this.messages.get("label.empty.loginpassword"), new Object[0]);
            this.loginValidated = false;
            this.flushContextCache();
            return;
        }
        List<ConnectProject> prjs = this.getProjectsAvailableForRegistration();
        if (prjs == null || prjs.size() == 0) {
            this.facesMessages.addToControl("online", StatusMessage.Severity.WARN, this.messages.get("label.bad.loginpassword.or.noproject"), new Object[0]);
            this.loginValidated = false;
            this.flushContextCache();
            return;
        }
        this.flushContextCache();
        this.loginValidated = true;
    }

    @Factory(value="connectServerReachable", scope=ScopeType.EVENT)
    public boolean isConnectServerReachable() {
        return !ConnectStatusHolder.instance().getStatus().isConnectServerUnreachable();
    }

    public String refreshStatus() {
        ConnectStatusHolder.instance().getStatus(true);
        this.flushContextCache();
        return null;
    }

    public SubscriptionStatusWrapper getStatus() {
        return ConnectStatusHolder.instance().getStatus();
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceDescription() {
        return this.instanceDescription;
    }

    public void setInstanceDescription(String instanceDescription) {
        this.instanceDescription = instanceDescription;
    }

    public String enterConnectCredentials() {
        if (this.login == null) {
            return "connectCredential";
        }
        return "projectListing";
    }

    @Factory(scope=ScopeType.EVENT, value="projectsForRegistration")
    public List<ConnectProject> getProjectsAvailableForRegistration() {
        List<Object> projects = new ArrayList<ConnectProject>();
        if (this.login != null) {
            try {
                projects = this.getService().getAvailableProjectsForRegistration(this.login, this.password);
                if (!projects.isEmpty()) {
                    Collections.sort(projects, new Comparator<ConnectProject>(){

                        @Override
                        public int compare(ConnectProject o1, ConnectProject o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while getting remote project", (Throwable)e);
            }
        }
        return projects;
    }

    public String resetRegister() {
        this.login = null;
        this.password = null;
        this.loginValidated = false;
        this.registredProject = null;
        this.instanceDescription = null;
        this.flushContextCache();
        return null;
    }

    public String register() {
        if (this.registredProject == null) {
            this.facesMessages.addToControl("online", StatusMessage.Severity.WARN, this.messages.get("label.empty.project"), new Object[0]);
            return null;
        }
        this.autofillInstanceDescription();
        try {
            this.getService().remoteRegisterInstance(this.login, this.password, this.registredProject, NuxeoClientInstanceType.fromString((String)this.instanceType), this.instanceDescription);
        }
        catch (Exception e) {
            this.facesMessages.addToControl("online", StatusMessage.Severity.ERROR, this.messages.get("label.connect.registrationError"), new Object[0]);
            log.error((Object)"Error while registering instance", (Throwable)e);
        }
        this.connectionStatusCache = null;
        this.flushContextCache();
        ConnectStatusHolder.instance().flush();
        return null;
    }

    protected void autofillInstanceDescription() {
        if (this.instanceDescription == null || this.instanceDescription.isEmpty()) {
            this.instanceDescription = this.login + "'s " + this.instanceType + " instance";
        }
    }

    public String getCTID() throws Exception {
        return TechnicalInstanceIdentifier.instance().getCTID();
    }

    public String localRegister() {
        this.autofillInstanceDescription();
        try {
            this.getService().localRegisterInstance(this.CLID, this.instanceDescription);
        }
        catch (LogicalInstanceIdentifier.InvalidCLID e) {
            this.facesMessages.addToControl("offline_clid", StatusMessage.Severity.WARN, this.messages.get("label.connect.wrongCLID"), new Object[0]);
        }
        catch (IOException e) {
            this.facesMessages.addToControl("offline_clid", StatusMessage.Severity.ERROR, this.messages.get("label.connect.registrationError"), new Object[0]);
            log.error((Object)"Error while registering instance locally", (Throwable)e);
        }
        this.flushContextCache();
        return null;
    }

    public String getPackageFileName() {
        return this.packageFileName;
    }

    public void setPackageFileName(String packageFileName) {
        this.packageFileName = packageFileName;
    }

    public Blob getPackageToUpload() {
        return this.packageToUpload;
    }

    public void setPackageToUpload(Blob packageToUpload) {
        this.packageToUpload = packageToUpload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadPackage() throws Exception {
        if (this.packageToUpload == null) {
            this.facesMessages.add(StatusMessage.Severity.WARN, "label.connect.nofile", new Object[0]);
            return;
        }
        PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        File tmpFile = File.createTempFile("upload", "nxpkg");
        this.packageToUpload.transferTo(tmpFile);
        try {
            pus.addPackage(tmpFile);
        }
        catch (Exception e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("label.connect.wrong.package:" + e.getMessage()), new Object[0]);
            return;
        }
        finally {
            tmpFile.delete();
            this.packageFileName = null;
            this.packageToUpload = null;
        }
    }

    public ConnectUpdateStatusInfo getDynamicConnectUpdateStatusInfo() {
        HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String bannerType = req.getParameter("bannerType");
        if ("unregistered".equals(bannerType)) {
            return ConnectUpdateStatusInfo.unregistered();
        }
        if ("notreachable".equals(bannerType)) {
            return ConnectUpdateStatusInfo.connectServerUnreachable();
        }
        if ("notvalid".equals(bannerType)) {
            return ConnectUpdateStatusInfo.notValid();
        }
        if ("ok".equals(bannerType)) {
            return ConnectUpdateStatusInfo.ok();
        }
        return this.getConnectUpdateStatusInfo();
    }

    @Factory(scope=ScopeType.APPLICATION, value="connectBannerEnabled")
    public boolean isConnectBannerEnabled() {
        String testerName = Framework.getProperty((String)"org.nuxeo.ecm.tester.name");
        return testerName == null || !testerName.equals("Nuxeo-Selenium-Tester");
    }

    @Factory(scope=ScopeType.APPLICATION, value="connectUpdateStatusInfo")
    public ConnectUpdateStatusInfo getConnectUpdateStatusInfo() {
        if (this.connectionStatusCache == null) {
            try {
                this.connectionStatusCache = !this.isRegistred() ? ConnectUpdateStatusInfo.unregistered() : (this.isConnectBannerEnabled() && this.isConnectServerReachable() ? (this.getStatus().isError() ? ConnectUpdateStatusInfo.connectServerUnreachable() : (ConnectStatusHolder.instance().getStatus().status() == SubscriptionStatusType.OK ? ConnectUpdateStatusInfo.ok() : ConnectUpdateStatusInfo.notValid())) : ConnectUpdateStatusInfo.connectServerUnreachable());
            }
            catch (Exception e) {
                log.error((Object)e);
                this.connectionStatusCache = null;
            }
        }
        return this.connectionStatusCache;
    }

    @Factory(value="nuxeoConnectUrl")
    public String getConnectServerUrl() {
        return ConnectUrlConfig.getBaseUrl();
    }
}

