/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.CallbackListener;

public class ReducedHTMLParser {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$util$ReducedHTMLParser == null ? (class$org$apache$myfaces$renderkit$html$util$ReducedHTMLParser = ReducedHTMLParser.class$("org.apache.myfaces.renderkit.html.util.ReducedHTMLParser")) : class$org$apache$myfaces$renderkit$html$util$ReducedHTMLParser));
    public static final int BODY_TAG = 0;
    public static final int HEAD_TAG = 1;
    public static final int SCRIPT_TAG = 2;
    private static final int STATE_READY = 0;
    private static final int STATE_IN_COMMENT = 1;
    private static final int STATE_IN_TAG = 2;
    private static final int STATE_IN_MARKED_SECTION = 3;
    private static final int STATE_EXPECTING_ETAGO = 4;
    private int _offset;
    private int _lineNumber;
    private CharSequence _seq;
    private CallbackListener _listener;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$util$ReducedHTMLParser;

    public static void parse(CharSequence seq, CallbackListener l) {
        new ReducedHTMLParser(seq, l).parse();
    }

    ReducedHTMLParser(CharSequence s, CallbackListener l) {
        this._seq = s;
        this._listener = l;
    }

    boolean isFinished() {
        return this._offset >= this._seq.length();
    }

    int getCurrentLineNumber() {
        return this._lineNumber;
    }

    void consumeWhitespace() {
        char c;
        boolean crSeen = false;
        while (this._offset < this._seq.length() && Character.isWhitespace(c = this._seq.charAt(this._offset))) {
            if (c == '\r') {
                ++this._lineNumber;
                crSeen = true;
            } else if (c == '\n' && !crSeen) {
                ++this._lineNumber;
            } else {
                crSeen = false;
            }
            ++this._offset;
        }
    }

    String consumeNonWhitespace() {
        char c;
        int wordStart = this._offset;
        while (this._offset < this._seq.length() && !Character.isWhitespace(c = this._seq.charAt(this._offset))) {
            ++this._offset;
        }
        if (wordStart == this._offset) {
            return null;
        }
        return ((Object)this._seq.subSequence(wordStart, this._offset)).toString();
    }

    boolean consumeMatch(String s) {
        int i;
        if (this._offset + s.length() > this._seq.length()) {
            return false;
        }
        for (i = 0; i < s.length(); ++i) {
            if (this._seq.charAt(this._offset + i) == s.charAt(i)) {
                continue;
            }
            return false;
        }
        this._offset += i;
        return true;
    }

    String consumeElementName() {
        this.consumeWhitespace();
        int nameStart = this._offset;
        while (!this.isFinished()) {
            boolean ok = false;
            char c = this._seq.charAt(this._offset);
            if (Character.isLetterOrDigit(this._seq.charAt(this._offset))) {
                ok = true;
            } else if (c == '_') {
                ok = true;
            } else if (c == '-') {
                ok = true;
            } else if (c == ':') {
                ok = true;
            }
            if (!ok) break;
            ++this._offset;
        }
        if (nameStart == this._offset) {
            return null;
        }
        return ((Object)this._seq.subSequence(nameStart, this._offset)).toString();
    }

    String consumeAttrName() {
        return this.consumeElementName();
    }

    String consumeString(char quote) {
        StringBuffer stringBuf = new StringBuffer();
        boolean escaping = false;
        while (!this.isFinished()) {
            char c = this._seq.charAt(this._offset);
            ++this._offset;
            if (c == quote) {
                if (!escaping) break;
                stringBuf.append(c);
                escaping = false;
                continue;
            }
            if (c == '\\') {
                if (escaping) {
                    stringBuf.append(c);
                    escaping = false;
                    continue;
                }
                escaping = true;
                continue;
            }
            if (escaping) {
                stringBuf.append('\\');
                escaping = false;
            }
            stringBuf.append(c);
        }
        return stringBuf.toString();
    }

    String consumeAttrValue() {
        this.consumeWhitespace();
        if (this.consumeMatch("'")) {
            return this.consumeString('\'');
        }
        if (this.consumeMatch("\"")) {
            return this.consumeString('\"');
        }
        return this.consumeNonWhitespace();
    }

    void consumeExcept(String s) {
        boolean crSeen = false;
        while (this._offset < this._seq.length()) {
            char c = this._seq.charAt(this._offset);
            if (s.indexOf(c) >= 0) {
                return;
            }
            if (c == '\r') {
                ++this._lineNumber;
                crSeen = true;
            } else if (c == '\n' && !crSeen) {
                ++this._lineNumber;
            } else {
                crSeen = false;
            }
            if (c == '\r') {
                ++this._lineNumber;
                crSeen = true;
            } else if (c == '\n' && !crSeen) {
                ++this._lineNumber;
            } else {
                crSeen = false;
            }
            ++this._offset;
        }
    }

    void parse() {
        int state = 0;
        int currentTagStart = -1;
        String currentTagName = null;
        this._lineNumber = 1;
        this._offset = 0;
        int lastOffset = this._offset - 1;
        while (this._offset < this._seq.length()) {
            if (this._offset <= lastOffset) {
                log.error((Object)"Infinite loop detected in ReducedHTMLParser; parsing skipped");
            }
            lastOffset = this._offset++;
            if (state == 0) {
                this.consumeExcept("<");
                if (this.isFinished()) break;
                if (this.consumeMatch("<!--")) {
                    state = 1;
                    continue;
                }
                if (this.consumeMatch("<![")) {
                    log.debug((Object)("Marked section found at line " + this.getCurrentLineNumber()));
                    state = 3;
                    continue;
                }
                if (this.consumeMatch("<!DOCTYPE")) {
                    log.debug((Object)("DOCTYPE found at line " + this.getCurrentLineNumber()));
                    continue;
                }
                if (this.consumeMatch("<?")) {
                    log.debug((Object)("PI found at line " + this.getCurrentLineNumber()));
                    continue;
                }
                if (this.consumeMatch("</")) {
                    if (!this.processEndTag()) {
                        return;
                    }
                    state = 0;
                    continue;
                }
                if (this.consumeMatch("<")) {
                    currentTagStart = this._offset - 1;
                    currentTagName = this.consumeElementName();
                    if (currentTagName == null) {
                        log.warn((Object)("Invalid HTML; bare lessthan sign found at line " + this.getCurrentLineNumber()));
                        continue;
                    }
                    state = 2;
                    continue;
                }
                throw new Error("Internal error at line " + this.getCurrentLineNumber());
            }
            if (state == 1) {
                this.consumeExcept("-");
                if (this.isFinished()) break;
                if (this.consumeMatch("-->")) {
                    state = 0;
                    continue;
                }
                this.consumeMatch("-");
                continue;
            }
            if (state == 2) {
                this.consumeWhitespace();
                if (this.consumeMatch("/>")) {
                    state = 0;
                    this.closedTag(currentTagStart, this._offset, currentTagName);
                    currentTagStart = -1;
                    currentTagName = null;
                    continue;
                }
                if (this.consumeMatch(">")) {
                    state = currentTagName.equalsIgnoreCase("script") || currentTagName.equalsIgnoreCase("style") ? 4 : 0;
                    this.openedTag(currentTagStart, this._offset, currentTagName);
                    currentTagStart = -1;
                    currentTagName = null;
                    continue;
                }
                String attrName = this.consumeAttrName();
                if (attrName == null) {
                    log.warn((Object)("Invalid tag found: unexpected input while looking for attr name or '/>' at line " + this.getCurrentLineNumber()));
                    state = 4;
                    continue;
                }
                this.consumeWhitespace();
                if (!this.consumeMatch("=")) continue;
                this.consumeAttrValue();
                continue;
            }
            if (state == 3) {
                this.consumeExcept("]");
                if (this.isFinished()) break;
                if (this.consumeMatch("]]>")) {
                    state = 0;
                    continue;
                }
                this.consumeMatch("]");
                continue;
            }
            if (state != 4) continue;
            this.consumeExcept("<");
            if (this.isFinished()) {
                log.debug((Object)"Malformed input page; input terminated while tag not closed.");
                break;
            }
            if (this.consumeMatch("</")) {
                if (!this.processEndTag()) {
                    return;
                }
                state = 0;
                continue;
            }
            this.consumeMatch("<");
        }
    }

    private boolean processEndTag() {
        int tagStart = this._offset - 2;
        String tagName = this.consumeElementName();
        this.consumeWhitespace();
        if (!this.consumeMatch(">")) {
            log.error((Object)("Malformed end tag at line " + this.getCurrentLineNumber() + "; skipping parsing"));
            return false;
        }
        this.closedTag(tagStart, this._offset, tagName);
        return true;
    }

    void openedTag(int startOffset, int endOffset, String tagName) {
        if ("head".equalsIgnoreCase(tagName)) {
            this._listener.openedStartTag(startOffset, 1);
            this._listener.closedStartTag(endOffset, 1);
        } else if ("body".equalsIgnoreCase(tagName)) {
            this._listener.openedStartTag(startOffset, 0);
            this._listener.closedStartTag(endOffset, 0);
        } else if ("script".equalsIgnoreCase(tagName)) {
            this._listener.openedStartTag(startOffset, 2);
            this._listener.closedStartTag(endOffset, 2);
        }
    }

    void closedTag(int startOffset, int endOffset, String tagName) {
        if ("head".equalsIgnoreCase(tagName)) {
            this._listener.openedEndTag(startOffset, 1);
            this._listener.closedEndTag(endOffset, 1);
        } else if ("body".equalsIgnoreCase(tagName)) {
            this._listener.openedEndTag(startOffset, 0);
            this._listener.closedEndTag(endOffset, 0);
        } else if ("script".equalsIgnoreCase(tagName)) {
            this._listener.openedEndTag(startOffset, 2);
            this._listener.closedEndTag(endOffset, 2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

