/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="pool")
public class NuxeoConnectionManagerConfiguration {
    public static final int DEFAULT_MAX_POOL_SIZE = 20;
    public static final int DEFAULT_MIN_POOL_SIZE = 0;
    public static final int DEFAULT_BLOCKING_TIMEOUT_MILLIS = 100;
    public static final int DEFAULT_IDLE_TIMEOUT_MINUTES = 0;
    @XNode(value="@name")
    private String name = "NuxeoConnectionManager";
    @XNode(value="@useTransactionCaching")
    private Boolean useTransactionCaching;
    @XNode(value="@useThreadCaching")
    private Boolean useThreadCaching;
    @XNode(value="@matchOne")
    private Boolean matchOne;
    @XNode(value="@matchAll")
    private Boolean matchAll;
    @XNode(value="@selectOneNoMatch")
    private Boolean selectOneNoMatch;
    @XNode(value="@partitionByConnectionRequestInfo")
    private Boolean partitionByConnectionRequestInfo;
    @XNode(value="@partitionBySubject")
    private Boolean partitionBySubject;
    @XNode(value="@maxPoolSize")
    private Integer maxPoolSize;
    @XNode(value="@minPoolSize")
    private Integer minPoolSize;
    @XNode(value="@blockingTimeoutMillis")
    private Integer blockingTimeoutMillis;
    @XNode(value="@idleTimeoutMinutes")
    private Integer idleTimeoutMinutes;

    public NuxeoConnectionManagerConfiguration() {
    }

    public NuxeoConnectionManagerConfiguration(NuxeoConnectionManagerConfiguration other) {
        this.name = other.name;
        this.useTransactionCaching = other.useTransactionCaching;
        this.useThreadCaching = other.useThreadCaching;
        this.matchOne = other.matchOne;
        this.matchAll = other.matchAll;
        this.selectOneNoMatch = other.selectOneNoMatch;
        this.partitionByConnectionRequestInfo = other.partitionByConnectionRequestInfo;
        this.partitionBySubject = other.partitionBySubject;
        this.maxPoolSize = other.maxPoolSize;
        this.minPoolSize = other.minPoolSize;
        this.blockingTimeoutMillis = other.blockingTimeoutMillis;
        this.idleTimeoutMinutes = other.idleTimeoutMinutes;
    }

    public void merge(NuxeoConnectionManagerConfiguration other) {
        if (other.name != null) {
            this.name = other.name;
        }
        if (other.useTransactionCaching != null) {
            this.useTransactionCaching = other.useTransactionCaching;
        }
        if (other.useThreadCaching != null) {
            this.useThreadCaching = other.useThreadCaching;
        }
        if (other.matchOne != null) {
            this.matchOne = other.matchOne;
        }
        if (other.matchAll != null) {
            this.matchAll = other.matchAll;
        }
        if (other.selectOneNoMatch != null) {
            this.selectOneNoMatch = other.selectOneNoMatch;
        }
        if (other.partitionByConnectionRequestInfo != null) {
            this.partitionByConnectionRequestInfo = other.partitionByConnectionRequestInfo;
        }
        if (other.partitionBySubject != null) {
            this.partitionBySubject = other.partitionBySubject;
        }
        if (other.maxPoolSize != null) {
            this.maxPoolSize = other.maxPoolSize;
        }
        if (other.minPoolSize != null) {
            this.minPoolSize = other.minPoolSize;
        }
        if (other.blockingTimeoutMillis != null) {
            this.blockingTimeoutMillis = other.blockingTimeoutMillis;
        }
        if (other.idleTimeoutMinutes != null) {
            this.idleTimeoutMinutes = other.idleTimeoutMinutes;
        }
    }

    private static boolean defaultFalse(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    private static boolean defaultTrue(Boolean bool) {
        return !Boolean.FALSE.equals(bool);
    }

    private static int defaultInt(Integer value, int def) {
        return value == null ? def : value;
    }

    public String getName() {
        return this.name;
    }

    public boolean getUseTransactionCaching() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.useTransactionCaching);
    }

    public boolean getUseThreadCaching() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.useThreadCaching);
    }

    public boolean getMatchOne() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.matchOne);
    }

    public boolean getMatchAll() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.matchAll);
    }

    public boolean getSelectOneNoMatch() {
        return NuxeoConnectionManagerConfiguration.defaultFalse(this.selectOneNoMatch);
    }

    public boolean getPartitionByConnectionRequestInfo() {
        return NuxeoConnectionManagerConfiguration.defaultFalse(this.partitionByConnectionRequestInfo);
    }

    public boolean getPartitionBySubject() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.partitionBySubject);
    }

    public int getMaxPoolSize() {
        return NuxeoConnectionManagerConfiguration.defaultInt(this.maxPoolSize, 20);
    }

    public int getMinPoolSize() {
        return NuxeoConnectionManagerConfiguration.defaultInt(this.minPoolSize, 0);
    }

    public int getBlockingTimeoutMillis() {
        return NuxeoConnectionManagerConfiguration.defaultInt(this.blockingTimeoutMillis, 100);
    }

    public int getIdleTimeoutMinutes() {
        return NuxeoConnectionManagerConfiguration.defaultInt(this.idleTimeoutMinutes, 0);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUseTransactionCaching(boolean useTransactionCaching) {
        this.useTransactionCaching = useTransactionCaching;
    }

    public void setUseThreadCaching(boolean useThreadCaching) {
        this.useThreadCaching = useThreadCaching;
    }

    public void setMatchOne(boolean matchOne) {
        this.matchOne = matchOne;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public void setSelectOneNoMatch(boolean selectOneNoMatch) {
        this.selectOneNoMatch = selectOneNoMatch;
    }

    public void setPartitionByConnectionRequestInfo(boolean partitionByConnectionRequestInfo) {
        this.partitionByConnectionRequestInfo = partitionByConnectionRequestInfo;
    }

    public void setPartitionBySubject(boolean partitionBySubject) {
        this.partitionBySubject = partitionBySubject;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setBlockingTimeoutMillis(int blockingTimeoutMillis) {
        this.blockingTimeoutMillis = blockingTimeoutMillis;
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.idleTimeoutMinutes = idleTimeoutMinutes;
    }
}

