/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.jaxrs.io.operations.ExecutionRequest;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="op", type="OperationService")
@Produces(value={"application/json+nxentity", "application/json+esentity", "application/json"})
public class OperationAdapter
extends DefaultAdapter {
    public static final String NAME = "op";

    @POST
    @Path(value="{operationName}")
    public Response doPost(@PathParam(value="operationName") String oid, @Context HttpServletRequest request, ExecutionRequest xreq) {
        try {
            AutomationServer srv = (AutomationServer)Framework.getLocalService(AutomationServer.class);
            if (!srv.accept(oid, false, request)) {
                return ResponseHelper.notFound();
            }
            AutomationService service = (AutomationService)Framework.getLocalService(AutomationService.class);
            OperationType operationType = service.getOperation(oid);
            if (operationType instanceof ChainTypeImpl) {
                OperationChain chain = ((ChainTypeImpl)operationType).getChain();
                if (!chain.getOperations().isEmpty()) {
                    operationType = service.getOperation(((OperationParameters)chain.getOperations().get(0)).id());
                } else {
                    throw new WebException("Chain '" + oid + "' doesn't contain any operation");
                }
            }
            for (InvokableMethod method : operationType.getMethods()) {
                if (this.getTarget().getAdapter(method.getInputType()) == null) continue;
                xreq.setInput(this.getTarget().getAdapter(method.getInputType()));
                break;
            }
            OperationContext ctx = xreq.createContext(request, this.getContext().getCoreSession());
            return Response.ok((Object)service.run(ctx, oid, xreq.getParams())).build();
        }
        catch (Exception e) {
            throw WebException.wrap((String)("Failed to execute operation: " + oid), (Throwable)e);
        }
    }
}

