/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.liveedit;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.webapp.liveedit.LiveEditClientConfig;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.EVENT)
@Name(value="liveEditHelper")
public class LiveEditBootstrapHelper
implements Serializable,
LiveEditConstants {
    protected static final String MODIFIED_FIELD = "modified";
    protected static final String DUBLINCORE_SCHEMA = "dublincore";
    private static final Log log = LogFactory.getLog(LiveEditBootstrapHelper.class);
    private static final long serialVersionUID = 876879071L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @RequestParameter
    protected String action;
    @RequestParameter
    protected String repoID;
    @RequestParameter
    protected String templateRepoID;
    @RequestParameter
    protected String docRef;
    @RequestParameter
    protected String templateDocRef;
    @In(create=true)
    protected LiveEditClientConfig liveEditClientConfig;
    @Deprecated
    @RequestParameter
    protected String schema;
    @RequestParameter
    protected String templateSchema;
    @Deprecated
    @RequestParameter
    protected String blobField;
    @RequestParameter
    protected String blobPropertyName;
    @RequestParameter
    protected String templateBlobField;
    @Deprecated
    @RequestParameter
    protected String filenameField;
    @RequestParameter
    protected String filenamePropertyName;
    @RequestParameter
    protected String mimetype;
    @RequestParameter
    protected String docType;
    protected MimetypeRegistry mimetypeRegistry;
    protected final Map<String, Boolean> cachedEditableStates = new HashMap<String, Boolean>();
    protected final Map<String, Boolean> cachedEditableBlobs = new HashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBootstrap() throws Exception {
        String currentRepoID = this.documentManager.getRepositoryName();
        CoreSession session = this.documentManager;
        CoreSession templateSession = this.documentManager;
        try {
            Blob blob;
            if (this.repoID != null && !currentRepoID.equals(this.repoID)) {
                session = CoreInstance.openCoreSession((String)this.repoID);
            }
            if (this.templateRepoID != null && !currentRepoID.equals(this.templateRepoID)) {
                templateSession = CoreInstance.openCoreSession((String)this.templateRepoID);
            }
            DocumentModel doc = null;
            DocumentModel templateDoc = null;
            String filename = null;
            if ("edit".equals(this.action)) {
                doc = session.getDocument((DocumentRef)new IdRef(this.docRef));
                this.docType = doc.getType();
                blob = null;
                if (this.blobPropertyName != null) {
                    blob = (Blob)doc.getPropertyValue(this.blobPropertyName);
                    if (blob == null) {
                        throw new ClientException(String.format("could not find blob to edit with property '%s'", this.blobPropertyName));
                    }
                } else {
                    blob = (Blob)doc.getProperty(this.schema, this.blobField);
                    if (blob == null) {
                        throw new ClientException(String.format("could not find blob to edit with schema '%s' and field '%s'", this.schema, this.blobField));
                    }
                }
                this.mimetype = blob.getMimeType();
                filename = this.filenamePropertyName != null ? (String)((Object)doc.getPropertyValue(this.filenamePropertyName)) : (String)doc.getProperty(this.schema, this.filenameField);
            } else if (!"create".equals(this.action)) {
                if ("createFromTemplate".equals(this.action)) {
                    templateDoc = templateSession.getDocument((DocumentRef)new IdRef(this.templateDocRef));
                    blob = (Blob)templateDoc.getProperty(this.templateSchema, this.templateBlobField);
                    if (blob == null) {
                        throw new ClientException(String.format("could not find template blob with schema '%s' and field '%s'", this.templateSchema, this.templateBlobField));
                    }
                    this.mimetype = blob.getMimeType();
                } else {
                    throw new ClientException(String.format("action '%s' is not a valid LiveEdit action: should be one of '%s', '%s' or '%s'", this.action, "create", "createFromTemplate", "edit"));
                }
            }
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            Element root = DocumentFactory.getInstance().createElement(liveEditTag);
            root.addNamespace("", "http://www.nuxeo.org/liveEdit");
            Element actionInfo = root.addElement(actionSelectorTag);
            actionInfo.setText(this.action);
            Element docInfo = root.addElement(documentTag);
            LiveEditBootstrapHelper.addTextElement(docInfo, docRefTag, this.docRef);
            Element docPathT = docInfo.addElement(docPathTag);
            Element docTitleT = docInfo.addElement(docTitleTag);
            if (doc != null) {
                docPathT.setText(doc.getPathAsString());
                docTitleT.setText(doc.getTitle());
            }
            LiveEditBootstrapHelper.addTextElement(docInfo, docRepositoryTag, this.repoID);
            LiveEditBootstrapHelper.addTextElement(docInfo, docSchemaNameTag, this.schema);
            LiveEditBootstrapHelper.addTextElement(docInfo, docFieldNameTag, this.blobField);
            LiveEditBootstrapHelper.addTextElement(docInfo, docBlobFieldNameTag, this.blobField);
            Element docFieldPathT = docInfo.addElement(docfieldPathTag);
            Element docBlobFieldPathT = docInfo.addElement(docBlobFieldPathTag);
            if (this.blobPropertyName != null) {
                docFieldPathT.setText(this.blobPropertyName);
                docBlobFieldPathT.setText(this.blobPropertyName);
            } else if (this.schema != null && this.blobField != null) {
                docFieldPathT.setText(this.schema + ':' + this.blobField);
                docBlobFieldPathT.setText(this.schema + ':' + this.blobField);
            }
            LiveEditBootstrapHelper.addTextElement(docInfo, docFilenameFieldNameTag, this.filenameField);
            Element docFilenameFieldPathT = docInfo.addElement(docFilenameFieldPathTag);
            if (this.filenamePropertyName != null) {
                docFilenameFieldPathT.setText(this.filenamePropertyName);
            } else if (this.schema != null && this.blobField != null) {
                docFilenameFieldPathT.setText(this.schema + ':' + this.filenameField);
            }
            LiveEditBootstrapHelper.addTextElement(docInfo, docfileNameTag, filename);
            LiveEditBootstrapHelper.addTextElement(docInfo, docTypeTag, this.docType);
            LiveEditBootstrapHelper.addTextElement(docInfo, docMimetypeTag, this.mimetype);
            LiveEditBootstrapHelper.addTextElement(docInfo, docFileExtensionTag, this.getFileExtension(this.mimetype));
            Element docFileAuthorizedExtensions = docInfo.addElement(docFileAuthorizedExtensionsTag);
            List<String> authorizedExtensions = this.getFileExtensions(this.mimetype);
            if (authorizedExtensions != null) {
                for (String extension : authorizedExtensions) {
                    LiveEditBootstrapHelper.addTextElement(docFileAuthorizedExtensions, docFileAuthorizedExtensionTag, extension);
                }
            }
            Element docIsVersionT = docInfo.addElement(docIsVersionTag);
            Element docIsLockedT = docInfo.addElement(docIsLockedTag);
            if ("edit".equals(this.action)) {
                docIsVersionT.setText(Boolean.toString(doc.isVersion()));
                docIsLockedT.setText(Boolean.toString(doc.isLocked()));
            }
            Element templateDocInfo = root.addElement(templateDocumentTag);
            LiveEditBootstrapHelper.addTextElement(templateDocInfo, docRefTag, this.templateDocRef);
            docPathT = templateDocInfo.addElement(docPathTag);
            docTitleT = templateDocInfo.addElement(docTitleTag);
            if (templateDoc != null) {
                docPathT.setText(templateDoc.getPathAsString());
                docTitleT.setText(templateDoc.getTitle());
            }
            LiveEditBootstrapHelper.addTextElement(templateDocInfo, docRepositoryTag, this.templateRepoID);
            LiveEditBootstrapHelper.addTextElement(templateDocInfo, docSchemaNameTag, this.templateSchema);
            LiveEditBootstrapHelper.addTextElement(templateDocInfo, docFieldNameTag, this.templateBlobField);
            LiveEditBootstrapHelper.addTextElement(templateDocInfo, docBlobFieldNameTag, this.templateBlobField);
            docFieldPathT = templateDocInfo.addElement(docfieldPathTag);
            docBlobFieldPathT = templateDocInfo.addElement(docBlobFieldPathTag);
            if (this.templateSchema != null && this.templateBlobField != null) {
                docFieldPathT.setText(this.templateSchema + ":" + this.templateBlobField);
                docBlobFieldPathT.setText(this.templateSchema + ":" + this.templateBlobField);
            }
            LiveEditBootstrapHelper.addTextElement(templateDocInfo, docMimetypeTag, this.mimetype);
            LiveEditBootstrapHelper.addTextElement(templateDocInfo, docFileExtensionTag, this.getFileExtension(this.mimetype));
            Element templateFileAuthorizedExtensions = templateDocInfo.addElement(docFileAuthorizedExtensionsTag);
            if (authorizedExtensions != null) {
                for (String extension : authorizedExtensions) {
                    LiveEditBootstrapHelper.addTextElement(templateFileAuthorizedExtensions, docFileAuthorizedExtensionTag, extension);
                }
            }
            Element requestInfo = root.addElement(requestInfoTag);
            Cookie[] cookies = request.getCookies();
            Element cookiesT = requestInfo.addElement(requestCookiesTag);
            for (Cookie cookie : cookies) {
                Element cookieT = cookiesT.addElement(requestCookieTag);
                cookieT.addAttribute("name", cookie.getName());
                cookieT.setText(cookie.getValue());
            }
            Element headersT = requestInfo.addElement(requestHeadersTag);
            Enumeration hEnum = request.getHeaderNames();
            while (hEnum.hasMoreElements()) {
                String hName = (String)hEnum.nextElement();
                if (hName.equalsIgnoreCase("cookie")) continue;
                Element headerT = headersT.addElement(requestHeaderTag);
                headerT.addAttribute("name", hName);
                headerT.setText(request.getHeader(hName));
            }
            LiveEditBootstrapHelper.addTextElement(requestInfo, requestBaseURLTag, BaseURL.getBaseURL((ServletRequest)request));
            String username = context.getExternalContext().getUserPrincipal().getName();
            Element userInfo = root.addElement(userInfoTag);
            LiveEditBootstrapHelper.addTextElement(userInfo, userNameTag, username);
            LiveEditBootstrapHelper.addTextElement(userInfo, userPasswordTag, "");
            LiveEditBootstrapHelper.addTextElement(userInfo, userTokenTag, "");
            LiveEditBootstrapHelper.addTextElement(userInfo, userLocaleTag, context.getViewRoot().getLocale().toString());
            String baseUrl = BaseURL.getBaseURL((ServletRequest)request);
            Element wsdlLocations = root.addElement(wsdlLocationsTag);
            Element wsdlAccessWST = wsdlLocations.addElement(wsdlAccessWebServiceTag);
            wsdlAccessWST.setText(baseUrl + "webservices/nuxeoAccess?wsdl");
            Element wsdlEEWST = wsdlLocations.addElement(wsdlLEWebServiceTag);
            wsdlEEWST.setText(baseUrl + "webservices/nuxeoLEWS?wsdl");
            Element serverInfo = root.addElement(serverInfoTag);
            Element serverVersionT = serverInfo.addElement(serverVersionTag);
            serverVersionT.setText("5.1");
            Element editId = root.addElement(editIdTag);
            editId.setText(LiveEditBootstrapHelper.getEditId(doc, session, username));
            Document xmlDoc = DocumentFactory.getInstance().createDocument();
            xmlDoc.setRootElement(root);
            response.setContentType("text/xml; charset=UTF-8");
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            XMLWriter writer = new XMLWriter((OutputStream)response.getOutputStream(), format);
            writer.write(xmlDoc);
            response.flushBuffer();
            context.responseComplete();
        }
        finally {
            if (session != null && session != this.documentManager) {
                session.close();
            }
            if (templateSession != null && templateSession != this.documentManager) {
                templateSession.close();
            }
        }
    }

    protected String getFileExtension(String mimetype) throws Exception {
        if (mimetype == null) {
            return null;
        }
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        List extensions = mimetypeRegistry.getExtensionsFromMimetypeName(mimetype);
        if (extensions != null && !extensions.isEmpty()) {
            return (String)extensions.get(0);
        }
        return null;
    }

    protected List<String> getFileExtensions(String mimetype) throws Exception {
        if (mimetype == null) {
            return null;
        }
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        List extensions = mimetypeRegistry.getExtensionsFromMimetypeName(mimetype);
        return extensions;
    }

    protected static Element addTextElement(Element parent, QName newElementName, String value) {
        Element element = parent.addElement(newElementName);
        if (value != null) {
            element.setText(value);
        }
        return element;
    }

    protected static String getEditId(DocumentModel doc, CoreSession session, String userName) {
        StringBuilder sb = new StringBuilder();
        if (doc != null) {
            sb.append(doc.getId());
        } else {
            sb.append("NewDocument");
        }
        sb.append('-');
        sb.append(session.getRepositoryName());
        sb.append('-');
        sb.append(userName);
        Calendar modified = null;
        if (doc != null) {
            try {
                modified = (Calendar)doc.getProperty(DUBLINCORE_SCHEMA, MODIFIED_FIELD);
            }
            catch (ClientException e) {
                modified = null;
            }
        }
        if (modified == null) {
            modified = Calendar.getInstance();
        }
        sb.append('-');
        sb.append(modified.getTimeInMillis());
        return sb.toString();
    }

    @Deprecated
    public boolean isLiveEditable(Blob blob) throws ClientException {
        if (blob == null) {
            return false;
        }
        String mimetype = blob.getMimeType();
        return this.isMimeTypeLiveEditable(mimetype);
    }

    public boolean isLiveEditable(DocumentModel document, Blob blob) throws ClientException {
        if (document.isImmutable()) {
            return false;
        }
        if (blob == null) {
            return false;
        }
        String mimetype = blob.getMimeType();
        return this.isMimeTypeLiveEditable(mimetype);
    }

    public boolean isMimeTypeLiveEditable(Blob blob) throws ClientException {
        if (blob == null) {
            return false;
        }
        String mimetype = blob.getMimeType();
        return this.isMimeTypeLiveEditable(mimetype);
    }

    public boolean isMimeTypeLiveEditable(String mimetype) throws ClientException {
        Boolean isEditable = this.cachedEditableStates.get(mimetype);
        if (isEditable == null) {
            if (this.liveEditClientConfig.getLiveEditConfigurationPolicy().equals("client")) {
                isEditable = this.liveEditClientConfig.isMimeTypeLiveEditable(mimetype);
                this.cachedEditableStates.put(mimetype, isEditable);
                return isEditable;
            }
            try {
                MimetypeEntry mimetypeEntry = this.getMimetypeRegistry().getMimetypeEntryByMimeType(mimetype);
                isEditable = mimetypeEntry == null ? Boolean.FALSE : Boolean.valueOf(mimetypeEntry.isOnlineEditable());
            }
            catch (Throwable t) {
                throw ClientException.wrap((Throwable)t);
            }
            if (this.liveEditClientConfig.getLiveEditConfigurationPolicy().equals("both")) {
                boolean isEditableOnClient = this.liveEditClientConfig.isMimeTypeLiveEditable(mimetype);
                isEditable = isEditable != false && isEditableOnClient;
            }
            this.cachedEditableStates.put(mimetype, isEditable);
        }
        return isEditable;
    }

    @Factory(value="msword_liveeditable", scope=ScopeType.SESSION)
    public boolean isMSWordLiveEdititable() throws ClientException {
        return this.isMimeTypeLiveEditable("application/msword");
    }

    @Factory(value="msexcel_liveeditable", scope=ScopeType.SESSION)
    public boolean isMSExcelLiveEdititable() throws ClientException {
        return this.isMimeTypeLiveEditable("application/vnd.ms-excel");
    }

    @Factory(value="mspowerpoint_liveeditable", scope=ScopeType.SESSION)
    public boolean isMSPowerpointLiveEdititable() throws ClientException {
        return this.isMimeTypeLiveEditable("application/vnd.ms-powerpoint");
    }

    @Factory(value="ootext_liveeditable", scope=ScopeType.SESSION)
    public boolean isOOTextLiveEdititable() throws ClientException {
        return this.isMimeTypeLiveEditable("application/vnd.oasis.opendocument.text");
    }

    @Factory(value="oocalc_liveeditable", scope=ScopeType.SESSION)
    public boolean isOOCalcLiveEdititable() throws ClientException {
        return this.isMimeTypeLiveEditable("application/vnd.oasis.opendocument.spreadsheet");
    }

    @Factory(value="oopresentation_liveeditable", scope=ScopeType.SESSION)
    public boolean isOOPresentationLiveEdititable() throws ClientException {
        return this.isMimeTypeLiveEditable("application/vnd.oasis.opendocument.presentation");
    }

    public boolean isCurrentDocumentLiveEditable() throws ClientException {
        return this.isDocumentLiveEditable(this.navigationContext.getCurrentDocument(), "file", "content");
    }

    public boolean isCurrentDocumentLiveEditable(String schemaName, String fieldName) throws ClientException {
        return this.isDocumentLiveEditable(this.navigationContext.getCurrentDocument(), schemaName, fieldName);
    }

    public boolean isCurrentDocumentLiveEditable(String propertyName) throws ClientException {
        return this.isDocumentLiveEditable(this.navigationContext.getCurrentDocument(), propertyName);
    }

    public boolean isDocumentLiveEditable(DocumentModel documentModel, String schemaName, String fieldName) throws ClientException {
        return this.isDocumentLiveEditable(documentModel, schemaName + ":" + fieldName);
    }

    public boolean isDocumentLiveEditable(DocumentModel documentModel, String propertyName) throws ClientException {
        if (documentModel == null) {
            log.warn((Object)"cannot check live editable state of null DocumentModel");
            return false;
        }
        if (!this.liveEditClientConfig.isLiveEditInstalled()) {
            return false;
        }
        String cacheKey = documentModel.getRef() + "__" + propertyName;
        Boolean cachedEditableBlob = this.cachedEditableBlobs.get(cacheKey);
        if (cachedEditableBlob == null) {
            Blob blob;
            if (documentModel.hasFacet("Immutable")) {
                return this.cacheBlobToFalse(cacheKey);
            }
            try {
                if (!this.documentManager.hasPermission(documentModel.getRef(), "WriteProperties")) {
                    return this.cacheBlobToFalse(cacheKey);
                }
            }
            catch (ClientException e) {
                log.warn((Object)String.format("document '%s' with reference '%s' no longer exists in the database, please ensure the indexes are up to date", documentModel.getTitle(), documentModel.getRef()));
                return this.cacheBlobToFalse(cacheKey);
            }
            try {
                blob = (Blob)documentModel.getProperty(propertyName).getValue(Blob.class);
            }
            catch (Exception e) {
                return this.cacheBlobToFalse(cacheKey);
            }
            cachedEditableBlob = this.isLiveEditable(blob);
            this.cachedEditableBlobs.put(cacheKey, cachedEditableBlob);
        }
        return cachedEditableBlob;
    }

    protected boolean cacheBlobToFalse(String cacheKey) {
        this.cachedEditableBlobs.put(cacheKey, Boolean.FALSE);
        return false;
    }

    protected MimetypeRegistry getMimetypeRegistry() throws Exception {
        if (this.mimetypeRegistry == null) {
            this.mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        return this.mimetypeRegistry;
    }
}

