/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.local.LoginStack;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginComponent;

public class CoreInstance {
    private static final CoreInstance INSTANCE = new CoreInstance();
    private final Map<String, RegistrationInfo> sessions = new ConcurrentHashMap<String, RegistrationInfo>();

    private CoreInstance() {
    }

    public static CoreInstance getInstance() {
        return INSTANCE;
    }

    public static CoreSession openCoreSession(String repositoryName) throws ClientException {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal((String)null));
    }

    public static CoreSession openCoreSession(String repositoryName, String username) throws ClientException {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal(username));
    }

    public static CoreSession openCoreSessionSystem(String repositoryName) throws ClientException {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal("system"));
    }

    @Deprecated
    public CoreSession open(String repositoryName, Map<String, Serializable> context) throws ClientException {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal(context));
    }

    public static CoreSession openCoreSession(String repositoryName, Map<String, Serializable> context) throws ClientException {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal(context));
    }

    public static CoreSession openCoreSession(String repositoryName, Principal principal) throws ClientException {
        if (principal instanceof NuxeoPrincipal) {
            return CoreInstance.openCoreSession(repositoryName, (NuxeoPrincipal)principal);
        }
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal(principal.getName()));
    }

    public static CoreSession openCoreSession(String repositoryName, NuxeoPrincipal principal) throws ClientException {
        if (repositoryName == null) {
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
            repositoryName = repositoryManager.getDefaultRepository().getName();
        }
        return CoreInstance.getInstance().acquireCoreSession(repositoryName, principal);
    }

    protected CoreSession acquireCoreSession(String repositoryName, NuxeoPrincipal principal) throws ClientException {
        CoreSession session = (CoreSession)Framework.getLocalService(CoreSession.class);
        session.connect(repositoryName, principal);
        this.sessions.put(session.getSessionId(), new RegistrationInfo(session));
        return session;
    }

    public CoreSession getSession(String sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("null sessionId");
        }
        RegistrationInfo csi = this.sessions.get(sessionId);
        return csi == null ? null : csi.session;
    }

    public static void closeCoreSession(CoreSession session) {
        CoreInstance.getInstance().releaseCoreSession(session);
    }

    protected void releaseCoreSession(CoreSession session) {
        String sessionId = session.getSessionId();
        RegistrationInfo csi = this.sessions.remove(sessionId);
        if (csi == null) {
            throw new RuntimeException("Closing unknown CoreSession: " + sessionId);
        }
        session.destroy();
    }

    protected static NuxeoPrincipal getPrincipal(Map<String, Serializable> map) throws ClientException {
        if (map == null) {
            return CoreInstance.getPrincipal((String)null);
        }
        NuxeoPrincipal principal = (NuxeoPrincipal)map.get("principal");
        if (principal == null) {
            principal = CoreInstance.getPrincipal((String)((Object)map.get("username")));
        }
        return principal;
    }

    protected static NuxeoPrincipal getPrincipal(String username) throws ClientException {
        if (username != null) {
            if ("system".equals(username)) {
                return new SystemPrincipal(null);
            }
            return new UserPrincipal(username, new ArrayList<String>(), false, false);
        }
        LoginStack.Entry entry = ClientLoginModule.getCurrentLogin();
        if (entry != null) {
            Principal p = entry.getPrincipal();
            if (p instanceof NuxeoPrincipal) {
                return (NuxeoPrincipal)p;
            }
            if (LoginComponent.isSystemLogin((Object)p)) {
                return new SystemPrincipal(p.getName());
            }
            throw new RuntimeException("Unsupported principal: " + p.getClass());
        }
        if (Framework.isTestModeSet()) {
            return new SystemPrincipal(null);
        }
        throw new ClientException("Cannot create a CoreSession outside a security context,  login() missing.");
    }

    @Deprecated
    public void close(CoreSession session) {
        session.close();
    }

    public int getNumberOfSessions() {
        return this.sessions.size();
    }

    public Collection<RegistrationInfo> getRegistrationInfos() {
        return this.sessions.values();
    }

    public static class RegistrationInfo
    extends Throwable {
        private static final long serialVersionUID = 1L;
        public final CoreSession session;

        public RegistrationInfo(CoreSession session) {
            super("RegistrationInfo(" + Thread.currentThread().getName() + ", " + session.getSessionId() + ")");
            this.session = session;
        }
    }
}

